/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkViewportSwizzleNV
extends Struct<VkViewportSwizzleNV>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;
    public static final int Z;
    public static final int W;

    protected VkViewportSwizzleNV(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkViewportSwizzleNV create(long address, @Nullable ByteBuffer container) {
        return new VkViewportSwizzleNV(address, container);
    }

    public VkViewportSwizzleNV(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkViewportSwizzleNV.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkViewportCoordinateSwizzleNV")
    public int x() {
        return VkViewportSwizzleNV.nx(this.address());
    }

    @NativeType(value="VkViewportCoordinateSwizzleNV")
    public int y() {
        return VkViewportSwizzleNV.ny(this.address());
    }

    @NativeType(value="VkViewportCoordinateSwizzleNV")
    public int z() {
        return VkViewportSwizzleNV.nz(this.address());
    }

    @NativeType(value="VkViewportCoordinateSwizzleNV")
    public int w() {
        return VkViewportSwizzleNV.nw(this.address());
    }

    public VkViewportSwizzleNV x(@NativeType(value="VkViewportCoordinateSwizzleNV") int value) {
        VkViewportSwizzleNV.nx(this.address(), value);
        return this;
    }

    public VkViewportSwizzleNV y(@NativeType(value="VkViewportCoordinateSwizzleNV") int value) {
        VkViewportSwizzleNV.ny(this.address(), value);
        return this;
    }

    public VkViewportSwizzleNV z(@NativeType(value="VkViewportCoordinateSwizzleNV") int value) {
        VkViewportSwizzleNV.nz(this.address(), value);
        return this;
    }

    public VkViewportSwizzleNV w(@NativeType(value="VkViewportCoordinateSwizzleNV") int value) {
        VkViewportSwizzleNV.nw(this.address(), value);
        return this;
    }

    public VkViewportSwizzleNV set(int x, int y, int z, int w) {
        this.x(x);
        this.y(y);
        this.z(z);
        this.w(w);
        return this;
    }

    public VkViewportSwizzleNV set(VkViewportSwizzleNV src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkViewportSwizzleNV malloc() {
        return new VkViewportSwizzleNV(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkViewportSwizzleNV calloc() {
        return new VkViewportSwizzleNV(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkViewportSwizzleNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkViewportSwizzleNV(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkViewportSwizzleNV create(long address) {
        return new VkViewportSwizzleNV(address, null);
    }

    public static @Nullable VkViewportSwizzleNV createSafe(long address) {
        return address == 0L ? null : new VkViewportSwizzleNV(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkViewportSwizzleNV.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkViewportSwizzleNV.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkViewportSwizzleNV mallocStack() {
        return VkViewportSwizzleNV.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkViewportSwizzleNV callocStack() {
        return VkViewportSwizzleNV.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkViewportSwizzleNV mallocStack(MemoryStack stack) {
        return VkViewportSwizzleNV.malloc(stack);
    }

    @Deprecated
    public static VkViewportSwizzleNV callocStack(MemoryStack stack) {
        return VkViewportSwizzleNV.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkViewportSwizzleNV.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkViewportSwizzleNV.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkViewportSwizzleNV.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkViewportSwizzleNV.calloc(capacity, stack);
    }

    public static VkViewportSwizzleNV malloc(MemoryStack stack) {
        return new VkViewportSwizzleNV(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkViewportSwizzleNV calloc(MemoryStack stack) {
        return new VkViewportSwizzleNV(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nx(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)X));
    }

    public static int ny(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)Y));
    }

    public static int nz(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)Z));
    }

    public static int nw(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)W));
    }

    public static void nx(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)X), (int)value);
    }

    public static void ny(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)Y), (int)value);
    }

    public static void nz(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)Z), (int)value);
    }

    public static void nw(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)W), (int)value);
    }

    static {
        Struct.Layout layout = VkViewportSwizzleNV.__struct((Struct.Member[])new Struct.Member[]{VkViewportSwizzleNV.__member((int)4), VkViewportSwizzleNV.__member((int)4), VkViewportSwizzleNV.__member((int)4), VkViewportSwizzleNV.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
        Z = layout.offsetof(2);
        W = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkViewportSwizzleNV, Buffer>
    implements NativeResource {
        private static final VkViewportSwizzleNV ELEMENT_FACTORY = VkViewportSwizzleNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkViewportSwizzleNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkViewportCoordinateSwizzleNV")
        public int x() {
            return VkViewportSwizzleNV.nx(this.address());
        }

        @NativeType(value="VkViewportCoordinateSwizzleNV")
        public int y() {
            return VkViewportSwizzleNV.ny(this.address());
        }

        @NativeType(value="VkViewportCoordinateSwizzleNV")
        public int z() {
            return VkViewportSwizzleNV.nz(this.address());
        }

        @NativeType(value="VkViewportCoordinateSwizzleNV")
        public int w() {
            return VkViewportSwizzleNV.nw(this.address());
        }

        public Buffer x(@NativeType(value="VkViewportCoordinateSwizzleNV") int value) {
            VkViewportSwizzleNV.nx(this.address(), value);
            return this;
        }

        public Buffer y(@NativeType(value="VkViewportCoordinateSwizzleNV") int value) {
            VkViewportSwizzleNV.ny(this.address(), value);
            return this;
        }

        public Buffer z(@NativeType(value="VkViewportCoordinateSwizzleNV") int value) {
            VkViewportSwizzleNV.nz(this.address(), value);
            return this;
        }

        public Buffer w(@NativeType(value="VkViewportCoordinateSwizzleNV") int value) {
            VkViewportSwizzleNV.nw(this.address(), value);
            return this;
        }
    }
}

