/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan.video;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.video.StdVideoDecodeH264ReferenceInfoFlags;

public class StdVideoDecodeH264ReferenceInfo
extends Struct<StdVideoDecodeH264ReferenceInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int FRAMENUM;
    public static final int RESERVED;
    public static final int PICORDERCNT;

    protected StdVideoDecodeH264ReferenceInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected StdVideoDecodeH264ReferenceInfo create(long address, @Nullable ByteBuffer container) {
        return new StdVideoDecodeH264ReferenceInfo(address, container);
    }

    public StdVideoDecodeH264ReferenceInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), StdVideoDecodeH264ReferenceInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public StdVideoDecodeH264ReferenceInfoFlags flags() {
        return StdVideoDecodeH264ReferenceInfo.nflags(this.address());
    }

    @NativeType(value="uint16_t")
    public short FrameNum() {
        return StdVideoDecodeH264ReferenceInfo.nFrameNum(this.address());
    }

    @NativeType(value="int32_t[STD_VIDEO_DECODE_H264_FIELD_ORDER_COUNT_LIST_SIZE]")
    public IntBuffer PicOrderCnt() {
        return StdVideoDecodeH264ReferenceInfo.nPicOrderCnt(this.address());
    }

    @NativeType(value="int32_t")
    public int PicOrderCnt(int index) {
        return StdVideoDecodeH264ReferenceInfo.nPicOrderCnt(this.address(), index);
    }

    public StdVideoDecodeH264ReferenceInfo flags(StdVideoDecodeH264ReferenceInfoFlags value) {
        StdVideoDecodeH264ReferenceInfo.nflags(this.address(), value);
        return this;
    }

    public StdVideoDecodeH264ReferenceInfo flags(Consumer<StdVideoDecodeH264ReferenceInfoFlags> consumer) {
        consumer.accept(this.flags());
        return this;
    }

    public StdVideoDecodeH264ReferenceInfo FrameNum(@NativeType(value="uint16_t") short value) {
        StdVideoDecodeH264ReferenceInfo.nFrameNum(this.address(), value);
        return this;
    }

    public StdVideoDecodeH264ReferenceInfo PicOrderCnt(@NativeType(value="int32_t[STD_VIDEO_DECODE_H264_FIELD_ORDER_COUNT_LIST_SIZE]") IntBuffer value) {
        StdVideoDecodeH264ReferenceInfo.nPicOrderCnt(this.address(), value);
        return this;
    }

    public StdVideoDecodeH264ReferenceInfo PicOrderCnt(int index, @NativeType(value="int32_t") int value) {
        StdVideoDecodeH264ReferenceInfo.nPicOrderCnt(this.address(), index, value);
        return this;
    }

    public StdVideoDecodeH264ReferenceInfo set(StdVideoDecodeH264ReferenceInfoFlags flags, short FrameNum, IntBuffer PicOrderCnt) {
        this.flags(flags);
        this.FrameNum(FrameNum);
        this.PicOrderCnt(PicOrderCnt);
        return this;
    }

    public StdVideoDecodeH264ReferenceInfo set(StdVideoDecodeH264ReferenceInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static StdVideoDecodeH264ReferenceInfo malloc() {
        return new StdVideoDecodeH264ReferenceInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static StdVideoDecodeH264ReferenceInfo calloc() {
        return new StdVideoDecodeH264ReferenceInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static StdVideoDecodeH264ReferenceInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new StdVideoDecodeH264ReferenceInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static StdVideoDecodeH264ReferenceInfo create(long address) {
        return new StdVideoDecodeH264ReferenceInfo(address, null);
    }

    public static @Nullable StdVideoDecodeH264ReferenceInfo createSafe(long address) {
        return address == 0L ? null : new StdVideoDecodeH264ReferenceInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)StdVideoDecodeH264ReferenceInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = StdVideoDecodeH264ReferenceInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static StdVideoDecodeH264ReferenceInfo malloc(MemoryStack stack) {
        return new StdVideoDecodeH264ReferenceInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static StdVideoDecodeH264ReferenceInfo calloc(MemoryStack stack) {
        return new StdVideoDecodeH264ReferenceInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static StdVideoDecodeH264ReferenceInfoFlags nflags(long struct) {
        return StdVideoDecodeH264ReferenceInfoFlags.create(struct + (long)FLAGS);
    }

    public static short nFrameNum(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)FRAMENUM));
    }

    public static short nreserved(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)RESERVED));
    }

    public static IntBuffer nPicOrderCnt(long struct) {
        return MemoryUtil.memIntBuffer((long)(struct + (long)PICORDERCNT), (int)2);
    }

    public static int nPicOrderCnt(long struct, int index) {
        return MemoryUtil.memGetInt((long)(struct + (long)PICORDERCNT + Checks.check((int)index, (int)2) * 4L));
    }

    public static void nflags(long struct, StdVideoDecodeH264ReferenceInfoFlags value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)FLAGS), (long)StdVideoDecodeH264ReferenceInfoFlags.SIZEOF);
    }

    public static void nFrameNum(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)FRAMENUM), (short)value);
    }

    public static void nreserved(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)RESERVED), (short)value);
    }

    public static void nPicOrderCnt(long struct, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)2);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((IntBuffer)value), (long)(struct + (long)PICORDERCNT), (long)(value.remaining() * 4));
    }

    public static void nPicOrderCnt(long struct, int index, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)PICORDERCNT + Checks.check((int)index, (int)2) * 4L), (int)value);
    }

    static {
        Struct.Layout layout = StdVideoDecodeH264ReferenceInfo.__struct((Struct.Member[])new Struct.Member[]{StdVideoDecodeH264ReferenceInfo.__member((int)StdVideoDecodeH264ReferenceInfoFlags.SIZEOF, (int)StdVideoDecodeH264ReferenceInfoFlags.ALIGNOF), StdVideoDecodeH264ReferenceInfo.__member((int)2), StdVideoDecodeH264ReferenceInfo.__member((int)2), StdVideoDecodeH264ReferenceInfo.__array((int)4, (int)2)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        FRAMENUM = layout.offsetof(1);
        RESERVED = layout.offsetof(2);
        PICORDERCNT = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<StdVideoDecodeH264ReferenceInfo, Buffer>
    implements NativeResource {
        private static final StdVideoDecodeH264ReferenceInfo ELEMENT_FACTORY = StdVideoDecodeH264ReferenceInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected StdVideoDecodeH264ReferenceInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public StdVideoDecodeH264ReferenceInfoFlags flags() {
            return StdVideoDecodeH264ReferenceInfo.nflags(this.address());
        }

        @NativeType(value="uint16_t")
        public short FrameNum() {
            return StdVideoDecodeH264ReferenceInfo.nFrameNum(this.address());
        }

        @NativeType(value="int32_t[STD_VIDEO_DECODE_H264_FIELD_ORDER_COUNT_LIST_SIZE]")
        public IntBuffer PicOrderCnt() {
            return StdVideoDecodeH264ReferenceInfo.nPicOrderCnt(this.address());
        }

        @NativeType(value="int32_t")
        public int PicOrderCnt(int index) {
            return StdVideoDecodeH264ReferenceInfo.nPicOrderCnt(this.address(), index);
        }

        public Buffer flags(StdVideoDecodeH264ReferenceInfoFlags value) {
            StdVideoDecodeH264ReferenceInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer flags(Consumer<StdVideoDecodeH264ReferenceInfoFlags> consumer) {
            consumer.accept(this.flags());
            return this;
        }

        public Buffer FrameNum(@NativeType(value="uint16_t") short value) {
            StdVideoDecodeH264ReferenceInfo.nFrameNum(this.address(), value);
            return this;
        }

        public Buffer PicOrderCnt(@NativeType(value="int32_t[STD_VIDEO_DECODE_H264_FIELD_ORDER_COUNT_LIST_SIZE]") IntBuffer value) {
            StdVideoDecodeH264ReferenceInfo.nPicOrderCnt(this.address(), value);
            return this;
        }

        public Buffer PicOrderCnt(int index, @NativeType(value="int32_t") int value) {
            StdVideoDecodeH264ReferenceInfo.nPicOrderCnt(this.address(), index, value);
            return this;
        }
    }
}

