/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan.video;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.video.StdVideoAV1CDEF;
import org.lwjgl.vulkan.video.StdVideoAV1GlobalMotion;
import org.lwjgl.vulkan.video.StdVideoAV1LoopFilter;
import org.lwjgl.vulkan.video.StdVideoAV1LoopRestoration;
import org.lwjgl.vulkan.video.StdVideoAV1Quantization;
import org.lwjgl.vulkan.video.StdVideoAV1Segmentation;
import org.lwjgl.vulkan.video.StdVideoAV1TileInfo;
import org.lwjgl.vulkan.video.StdVideoEncodeAV1ExtensionHeader;
import org.lwjgl.vulkan.video.StdVideoEncodeAV1PictureInfoFlags;

public class StdVideoEncodeAV1PictureInfo
extends Struct<StdVideoEncodeAV1PictureInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int FRAME_TYPE;
    public static final int FRAME_PRESENTATION_TIME;
    public static final int CURRENT_FRAME_ID;
    public static final int ORDER_HINT;
    public static final int PRIMARY_REF_FRAME;
    public static final int REFRESH_FRAME_FLAGS;
    public static final int CODED_DENOM;
    public static final int RENDER_WIDTH_MINUS_1;
    public static final int RENDER_HEIGHT_MINUS_1;
    public static final int INTERPOLATION_FILTER;
    public static final int TXMODE;
    public static final int DELTA_Q_RES;
    public static final int DELTA_LF_RES;
    public static final int REF_ORDER_HINT;
    public static final int REF_FRAME_IDX;
    public static final int RESERVED1;
    public static final int DELTA_FRAME_ID_MINUS_1;
    public static final int PTILEINFO;
    public static final int PQUANTIZATION;
    public static final int PSEGMENTATION;
    public static final int PLOOPFILTER;
    public static final int PCDEF;
    public static final int PLOOPRESTORATION;
    public static final int PGLOBALMOTION;
    public static final int PEXTENSIONHEADER;
    public static final int PBUFFERREMOVALTIMES;

    protected StdVideoEncodeAV1PictureInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected StdVideoEncodeAV1PictureInfo create(long address, @Nullable ByteBuffer container) {
        return new StdVideoEncodeAV1PictureInfo(address, container);
    }

    public StdVideoEncodeAV1PictureInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), StdVideoEncodeAV1PictureInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public StdVideoEncodeAV1PictureInfoFlags flags() {
        return StdVideoEncodeAV1PictureInfo.nflags(this.address());
    }

    @NativeType(value="StdVideoAV1FrameType")
    public int frame_type() {
        return StdVideoEncodeAV1PictureInfo.nframe_type(this.address());
    }

    @NativeType(value="uint32_t")
    public int frame_presentation_time() {
        return StdVideoEncodeAV1PictureInfo.nframe_presentation_time(this.address());
    }

    @NativeType(value="uint32_t")
    public int current_frame_id() {
        return StdVideoEncodeAV1PictureInfo.ncurrent_frame_id(this.address());
    }

    @NativeType(value="uint8_t")
    public byte order_hint() {
        return StdVideoEncodeAV1PictureInfo.norder_hint(this.address());
    }

    @NativeType(value="uint8_t")
    public byte primary_ref_frame() {
        return StdVideoEncodeAV1PictureInfo.nprimary_ref_frame(this.address());
    }

    @NativeType(value="uint8_t")
    public byte refresh_frame_flags() {
        return StdVideoEncodeAV1PictureInfo.nrefresh_frame_flags(this.address());
    }

    @NativeType(value="uint8_t")
    public byte coded_denom() {
        return StdVideoEncodeAV1PictureInfo.ncoded_denom(this.address());
    }

    @NativeType(value="uint16_t")
    public short render_width_minus_1() {
        return StdVideoEncodeAV1PictureInfo.nrender_width_minus_1(this.address());
    }

    @NativeType(value="uint16_t")
    public short render_height_minus_1() {
        return StdVideoEncodeAV1PictureInfo.nrender_height_minus_1(this.address());
    }

    @NativeType(value="StdVideoAV1InterpolationFilter")
    public int interpolation_filter() {
        return StdVideoEncodeAV1PictureInfo.ninterpolation_filter(this.address());
    }

    @NativeType(value="StdVideoAV1TxMode")
    public int TxMode() {
        return StdVideoEncodeAV1PictureInfo.nTxMode(this.address());
    }

    @NativeType(value="uint8_t")
    public byte delta_q_res() {
        return StdVideoEncodeAV1PictureInfo.ndelta_q_res(this.address());
    }

    @NativeType(value="uint8_t")
    public byte delta_lf_res() {
        return StdVideoEncodeAV1PictureInfo.ndelta_lf_res(this.address());
    }

    @NativeType(value="uint8_t[STD_VIDEO_AV1_NUM_REF_FRAMES]")
    public ByteBuffer ref_order_hint() {
        return StdVideoEncodeAV1PictureInfo.nref_order_hint(this.address());
    }

    @NativeType(value="uint8_t")
    public byte ref_order_hint(int index) {
        return StdVideoEncodeAV1PictureInfo.nref_order_hint(this.address(), index);
    }

    @NativeType(value="int8_t[STD_VIDEO_AV1_REFS_PER_FRAME]")
    public ByteBuffer ref_frame_idx() {
        return StdVideoEncodeAV1PictureInfo.nref_frame_idx(this.address());
    }

    @NativeType(value="int8_t")
    public byte ref_frame_idx(int index) {
        return StdVideoEncodeAV1PictureInfo.nref_frame_idx(this.address(), index);
    }

    @NativeType(value="uint32_t[STD_VIDEO_AV1_REFS_PER_FRAME]")
    public IntBuffer delta_frame_id_minus_1() {
        return StdVideoEncodeAV1PictureInfo.ndelta_frame_id_minus_1(this.address());
    }

    @NativeType(value="uint32_t")
    public int delta_frame_id_minus_1(int index) {
        return StdVideoEncodeAV1PictureInfo.ndelta_frame_id_minus_1(this.address(), index);
    }

    @NativeType(value="StdVideoAV1TileInfo const *")
    public StdVideoAV1TileInfo pTileInfo() {
        return StdVideoEncodeAV1PictureInfo.npTileInfo(this.address());
    }

    @NativeType(value="StdVideoAV1Quantization const *")
    public StdVideoAV1Quantization pQuantization() {
        return StdVideoEncodeAV1PictureInfo.npQuantization(this.address());
    }

    @NativeType(value="StdVideoAV1Segmentation const *")
    public StdVideoAV1Segmentation pSegmentation() {
        return StdVideoEncodeAV1PictureInfo.npSegmentation(this.address());
    }

    @NativeType(value="StdVideoAV1LoopFilter const *")
    public StdVideoAV1LoopFilter pLoopFilter() {
        return StdVideoEncodeAV1PictureInfo.npLoopFilter(this.address());
    }

    @NativeType(value="StdVideoAV1CDEF const *")
    public StdVideoAV1CDEF pCDEF() {
        return StdVideoEncodeAV1PictureInfo.npCDEF(this.address());
    }

    @NativeType(value="StdVideoAV1LoopRestoration const *")
    public StdVideoAV1LoopRestoration pLoopRestoration() {
        return StdVideoEncodeAV1PictureInfo.npLoopRestoration(this.address());
    }

    @NativeType(value="StdVideoAV1GlobalMotion const *")
    public StdVideoAV1GlobalMotion pGlobalMotion() {
        return StdVideoEncodeAV1PictureInfo.npGlobalMotion(this.address());
    }

    @NativeType(value="StdVideoEncodeAV1ExtensionHeader const *")
    public StdVideoEncodeAV1ExtensionHeader pExtensionHeader() {
        return StdVideoEncodeAV1PictureInfo.npExtensionHeader(this.address());
    }

    @NativeType(value="uint32_t const *")
    public IntBuffer pBufferRemovalTimes(int capacity) {
        return StdVideoEncodeAV1PictureInfo.npBufferRemovalTimes(this.address(), capacity);
    }

    public StdVideoEncodeAV1PictureInfo flags(StdVideoEncodeAV1PictureInfoFlags value) {
        StdVideoEncodeAV1PictureInfo.nflags(this.address(), value);
        return this;
    }

    public StdVideoEncodeAV1PictureInfo flags(Consumer<StdVideoEncodeAV1PictureInfoFlags> consumer) {
        consumer.accept(this.flags());
        return this;
    }

    public StdVideoEncodeAV1PictureInfo frame_type(@NativeType(value="StdVideoAV1FrameType") int value) {
        StdVideoEncodeAV1PictureInfo.nframe_type(this.address(), value);
        return this;
    }

    public StdVideoEncodeAV1PictureInfo frame_presentation_time(@NativeType(value="uint32_t") int value) {
        StdVideoEncodeAV1PictureInfo.nframe_presentation_time(this.address(), value);
        return this;
    }

    public StdVideoEncodeAV1PictureInfo current_frame_id(@NativeType(value="uint32_t") int value) {
        StdVideoEncodeAV1PictureInfo.ncurrent_frame_id(this.address(), value);
        return this;
    }

    public StdVideoEncodeAV1PictureInfo order_hint(@NativeType(value="uint8_t") byte value) {
        StdVideoEncodeAV1PictureInfo.norder_hint(this.address(), value);
        return this;
    }

    public StdVideoEncodeAV1PictureInfo primary_ref_frame(@NativeType(value="uint8_t") byte value) {
        StdVideoEncodeAV1PictureInfo.nprimary_ref_frame(this.address(), value);
        return this;
    }

    public StdVideoEncodeAV1PictureInfo refresh_frame_flags(@NativeType(value="uint8_t") byte value) {
        StdVideoEncodeAV1PictureInfo.nrefresh_frame_flags(this.address(), value);
        return this;
    }

    public StdVideoEncodeAV1PictureInfo coded_denom(@NativeType(value="uint8_t") byte value) {
        StdVideoEncodeAV1PictureInfo.ncoded_denom(this.address(), value);
        return this;
    }

    public StdVideoEncodeAV1PictureInfo render_width_minus_1(@NativeType(value="uint16_t") short value) {
        StdVideoEncodeAV1PictureInfo.nrender_width_minus_1(this.address(), value);
        return this;
    }

    public StdVideoEncodeAV1PictureInfo render_height_minus_1(@NativeType(value="uint16_t") short value) {
        StdVideoEncodeAV1PictureInfo.nrender_height_minus_1(this.address(), value);
        return this;
    }

    public StdVideoEncodeAV1PictureInfo interpolation_filter(@NativeType(value="StdVideoAV1InterpolationFilter") int value) {
        StdVideoEncodeAV1PictureInfo.ninterpolation_filter(this.address(), value);
        return this;
    }

    public StdVideoEncodeAV1PictureInfo TxMode(@NativeType(value="StdVideoAV1TxMode") int value) {
        StdVideoEncodeAV1PictureInfo.nTxMode(this.address(), value);
        return this;
    }

    public StdVideoEncodeAV1PictureInfo delta_q_res(@NativeType(value="uint8_t") byte value) {
        StdVideoEncodeAV1PictureInfo.ndelta_q_res(this.address(), value);
        return this;
    }

    public StdVideoEncodeAV1PictureInfo delta_lf_res(@NativeType(value="uint8_t") byte value) {
        StdVideoEncodeAV1PictureInfo.ndelta_lf_res(this.address(), value);
        return this;
    }

    public StdVideoEncodeAV1PictureInfo ref_order_hint(@NativeType(value="uint8_t[STD_VIDEO_AV1_NUM_REF_FRAMES]") ByteBuffer value) {
        StdVideoEncodeAV1PictureInfo.nref_order_hint(this.address(), value);
        return this;
    }

    public StdVideoEncodeAV1PictureInfo ref_order_hint(int index, @NativeType(value="uint8_t") byte value) {
        StdVideoEncodeAV1PictureInfo.nref_order_hint(this.address(), index, value);
        return this;
    }

    public StdVideoEncodeAV1PictureInfo ref_frame_idx(@NativeType(value="int8_t[STD_VIDEO_AV1_REFS_PER_FRAME]") ByteBuffer value) {
        StdVideoEncodeAV1PictureInfo.nref_frame_idx(this.address(), value);
        return this;
    }

    public StdVideoEncodeAV1PictureInfo ref_frame_idx(int index, @NativeType(value="int8_t") byte value) {
        StdVideoEncodeAV1PictureInfo.nref_frame_idx(this.address(), index, value);
        return this;
    }

    public StdVideoEncodeAV1PictureInfo delta_frame_id_minus_1(@NativeType(value="uint32_t[STD_VIDEO_AV1_REFS_PER_FRAME]") IntBuffer value) {
        StdVideoEncodeAV1PictureInfo.ndelta_frame_id_minus_1(this.address(), value);
        return this;
    }

    public StdVideoEncodeAV1PictureInfo delta_frame_id_minus_1(int index, @NativeType(value="uint32_t") int value) {
        StdVideoEncodeAV1PictureInfo.ndelta_frame_id_minus_1(this.address(), index, value);
        return this;
    }

    public StdVideoEncodeAV1PictureInfo pTileInfo(@NativeType(value="StdVideoAV1TileInfo const *") StdVideoAV1TileInfo value) {
        StdVideoEncodeAV1PictureInfo.npTileInfo(this.address(), value);
        return this;
    }

    public StdVideoEncodeAV1PictureInfo pQuantization(@NativeType(value="StdVideoAV1Quantization const *") StdVideoAV1Quantization value) {
        StdVideoEncodeAV1PictureInfo.npQuantization(this.address(), value);
        return this;
    }

    public StdVideoEncodeAV1PictureInfo pSegmentation(@NativeType(value="StdVideoAV1Segmentation const *") StdVideoAV1Segmentation value) {
        StdVideoEncodeAV1PictureInfo.npSegmentation(this.address(), value);
        return this;
    }

    public StdVideoEncodeAV1PictureInfo pLoopFilter(@NativeType(value="StdVideoAV1LoopFilter const *") StdVideoAV1LoopFilter value) {
        StdVideoEncodeAV1PictureInfo.npLoopFilter(this.address(), value);
        return this;
    }

    public StdVideoEncodeAV1PictureInfo pCDEF(@NativeType(value="StdVideoAV1CDEF const *") StdVideoAV1CDEF value) {
        StdVideoEncodeAV1PictureInfo.npCDEF(this.address(), value);
        return this;
    }

    public StdVideoEncodeAV1PictureInfo pLoopRestoration(@NativeType(value="StdVideoAV1LoopRestoration const *") StdVideoAV1LoopRestoration value) {
        StdVideoEncodeAV1PictureInfo.npLoopRestoration(this.address(), value);
        return this;
    }

    public StdVideoEncodeAV1PictureInfo pGlobalMotion(@NativeType(value="StdVideoAV1GlobalMotion const *") StdVideoAV1GlobalMotion value) {
        StdVideoEncodeAV1PictureInfo.npGlobalMotion(this.address(), value);
        return this;
    }

    public StdVideoEncodeAV1PictureInfo pExtensionHeader(@NativeType(value="StdVideoEncodeAV1ExtensionHeader const *") StdVideoEncodeAV1ExtensionHeader value) {
        StdVideoEncodeAV1PictureInfo.npExtensionHeader(this.address(), value);
        return this;
    }

    public StdVideoEncodeAV1PictureInfo pBufferRemovalTimes(@NativeType(value="uint32_t const *") IntBuffer value) {
        StdVideoEncodeAV1PictureInfo.npBufferRemovalTimes(this.address(), value);
        return this;
    }

    public StdVideoEncodeAV1PictureInfo set(StdVideoEncodeAV1PictureInfoFlags flags, int frame_type, int frame_presentation_time, int current_frame_id, byte order_hint, byte primary_ref_frame, byte refresh_frame_flags, byte coded_denom, short render_width_minus_1, short render_height_minus_1, int interpolation_filter, int TxMode, byte delta_q_res, byte delta_lf_res, ByteBuffer ref_order_hint, ByteBuffer ref_frame_idx, IntBuffer delta_frame_id_minus_1, StdVideoAV1TileInfo pTileInfo, StdVideoAV1Quantization pQuantization, StdVideoAV1Segmentation pSegmentation, StdVideoAV1LoopFilter pLoopFilter, StdVideoAV1CDEF pCDEF, StdVideoAV1LoopRestoration pLoopRestoration, StdVideoAV1GlobalMotion pGlobalMotion, StdVideoEncodeAV1ExtensionHeader pExtensionHeader, IntBuffer pBufferRemovalTimes) {
        this.flags(flags);
        this.frame_type(frame_type);
        this.frame_presentation_time(frame_presentation_time);
        this.current_frame_id(current_frame_id);
        this.order_hint(order_hint);
        this.primary_ref_frame(primary_ref_frame);
        this.refresh_frame_flags(refresh_frame_flags);
        this.coded_denom(coded_denom);
        this.render_width_minus_1(render_width_minus_1);
        this.render_height_minus_1(render_height_minus_1);
        this.interpolation_filter(interpolation_filter);
        this.TxMode(TxMode);
        this.delta_q_res(delta_q_res);
        this.delta_lf_res(delta_lf_res);
        this.ref_order_hint(ref_order_hint);
        this.ref_frame_idx(ref_frame_idx);
        this.delta_frame_id_minus_1(delta_frame_id_minus_1);
        this.pTileInfo(pTileInfo);
        this.pQuantization(pQuantization);
        this.pSegmentation(pSegmentation);
        this.pLoopFilter(pLoopFilter);
        this.pCDEF(pCDEF);
        this.pLoopRestoration(pLoopRestoration);
        this.pGlobalMotion(pGlobalMotion);
        this.pExtensionHeader(pExtensionHeader);
        this.pBufferRemovalTimes(pBufferRemovalTimes);
        return this;
    }

    public StdVideoEncodeAV1PictureInfo set(StdVideoEncodeAV1PictureInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static StdVideoEncodeAV1PictureInfo malloc() {
        return new StdVideoEncodeAV1PictureInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static StdVideoEncodeAV1PictureInfo calloc() {
        return new StdVideoEncodeAV1PictureInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static StdVideoEncodeAV1PictureInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new StdVideoEncodeAV1PictureInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static StdVideoEncodeAV1PictureInfo create(long address) {
        return new StdVideoEncodeAV1PictureInfo(address, null);
    }

    public static @Nullable StdVideoEncodeAV1PictureInfo createSafe(long address) {
        return address == 0L ? null : new StdVideoEncodeAV1PictureInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)StdVideoEncodeAV1PictureInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = StdVideoEncodeAV1PictureInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static StdVideoEncodeAV1PictureInfo malloc(MemoryStack stack) {
        return new StdVideoEncodeAV1PictureInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static StdVideoEncodeAV1PictureInfo calloc(MemoryStack stack) {
        return new StdVideoEncodeAV1PictureInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static StdVideoEncodeAV1PictureInfoFlags nflags(long struct) {
        return StdVideoEncodeAV1PictureInfoFlags.create(struct + (long)FLAGS);
    }

    public static int nframe_type(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FRAME_TYPE));
    }

    public static int nframe_presentation_time(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FRAME_PRESENTATION_TIME));
    }

    public static int ncurrent_frame_id(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)CURRENT_FRAME_ID));
    }

    public static byte norder_hint(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)ORDER_HINT));
    }

    public static byte nprimary_ref_frame(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)PRIMARY_REF_FRAME));
    }

    public static byte nrefresh_frame_flags(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)REFRESH_FRAME_FLAGS));
    }

    public static byte ncoded_denom(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)CODED_DENOM));
    }

    public static short nrender_width_minus_1(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)RENDER_WIDTH_MINUS_1));
    }

    public static short nrender_height_minus_1(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)RENDER_HEIGHT_MINUS_1));
    }

    public static int ninterpolation_filter(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)INTERPOLATION_FILTER));
    }

    public static int nTxMode(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TXMODE));
    }

    public static byte ndelta_q_res(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)DELTA_Q_RES));
    }

    public static byte ndelta_lf_res(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)DELTA_LF_RES));
    }

    public static ByteBuffer nref_order_hint(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)REF_ORDER_HINT), (int)8);
    }

    public static byte nref_order_hint(long struct, int index) {
        return MemoryUtil.memGetByte((long)(struct + (long)REF_ORDER_HINT + Checks.check((int)index, (int)8) * 1L));
    }

    public static ByteBuffer nref_frame_idx(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)REF_FRAME_IDX), (int)7);
    }

    public static byte nref_frame_idx(long struct, int index) {
        return MemoryUtil.memGetByte((long)(struct + (long)REF_FRAME_IDX + Checks.check((int)index, (int)7) * 1L));
    }

    public static ByteBuffer nreserved1(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)RESERVED1), (int)3);
    }

    public static byte nreserved1(long struct, int index) {
        return MemoryUtil.memGetByte((long)(struct + (long)RESERVED1 + Checks.check((int)index, (int)3) * 1L));
    }

    public static IntBuffer ndelta_frame_id_minus_1(long struct) {
        return MemoryUtil.memIntBuffer((long)(struct + (long)DELTA_FRAME_ID_MINUS_1), (int)7);
    }

    public static int ndelta_frame_id_minus_1(long struct, int index) {
        return MemoryUtil.memGetInt((long)(struct + (long)DELTA_FRAME_ID_MINUS_1 + Checks.check((int)index, (int)7) * 4L));
    }

    public static StdVideoAV1TileInfo npTileInfo(long struct) {
        return StdVideoAV1TileInfo.create(MemoryUtil.memGetAddress((long)(struct + (long)PTILEINFO)));
    }

    public static StdVideoAV1Quantization npQuantization(long struct) {
        return StdVideoAV1Quantization.create(MemoryUtil.memGetAddress((long)(struct + (long)PQUANTIZATION)));
    }

    public static StdVideoAV1Segmentation npSegmentation(long struct) {
        return StdVideoAV1Segmentation.create(MemoryUtil.memGetAddress((long)(struct + (long)PSEGMENTATION)));
    }

    public static StdVideoAV1LoopFilter npLoopFilter(long struct) {
        return StdVideoAV1LoopFilter.create(MemoryUtil.memGetAddress((long)(struct + (long)PLOOPFILTER)));
    }

    public static StdVideoAV1CDEF npCDEF(long struct) {
        return StdVideoAV1CDEF.create(MemoryUtil.memGetAddress((long)(struct + (long)PCDEF)));
    }

    public static StdVideoAV1LoopRestoration npLoopRestoration(long struct) {
        return StdVideoAV1LoopRestoration.create(MemoryUtil.memGetAddress((long)(struct + (long)PLOOPRESTORATION)));
    }

    public static StdVideoAV1GlobalMotion npGlobalMotion(long struct) {
        return StdVideoAV1GlobalMotion.create(MemoryUtil.memGetAddress((long)(struct + (long)PGLOBALMOTION)));
    }

    public static StdVideoEncodeAV1ExtensionHeader npExtensionHeader(long struct) {
        return StdVideoEncodeAV1ExtensionHeader.create(MemoryUtil.memGetAddress((long)(struct + (long)PEXTENSIONHEADER)));
    }

    public static IntBuffer npBufferRemovalTimes(long struct, int capacity) {
        return MemoryUtil.memIntBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)PBUFFERREMOVALTIMES)), (int)capacity);
    }

    public static void nflags(long struct, StdVideoEncodeAV1PictureInfoFlags value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)FLAGS), (long)StdVideoEncodeAV1PictureInfoFlags.SIZEOF);
    }

    public static void nframe_type(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)FRAME_TYPE), (int)value);
    }

    public static void nframe_presentation_time(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)FRAME_PRESENTATION_TIME), (int)value);
    }

    public static void ncurrent_frame_id(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)CURRENT_FRAME_ID), (int)value);
    }

    public static void norder_hint(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)ORDER_HINT), (byte)value);
    }

    public static void nprimary_ref_frame(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)PRIMARY_REF_FRAME), (byte)value);
    }

    public static void nrefresh_frame_flags(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)REFRESH_FRAME_FLAGS), (byte)value);
    }

    public static void ncoded_denom(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)CODED_DENOM), (byte)value);
    }

    public static void nrender_width_minus_1(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)RENDER_WIDTH_MINUS_1), (short)value);
    }

    public static void nrender_height_minus_1(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)RENDER_HEIGHT_MINUS_1), (short)value);
    }

    public static void ninterpolation_filter(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)INTERPOLATION_FILTER), (int)value);
    }

    public static void nTxMode(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TXMODE), (int)value);
    }

    public static void ndelta_q_res(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)DELTA_Q_RES), (byte)value);
    }

    public static void ndelta_lf_res(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)DELTA_LF_RES), (byte)value);
    }

    public static void nref_order_hint(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)8);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)REF_ORDER_HINT), (long)(value.remaining() * 1));
    }

    public static void nref_order_hint(long struct, int index, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)REF_ORDER_HINT + Checks.check((int)index, (int)8) * 1L), (byte)value);
    }

    public static void nref_frame_idx(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)7);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)REF_FRAME_IDX), (long)(value.remaining() * 1));
    }

    public static void nref_frame_idx(long struct, int index, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)REF_FRAME_IDX + Checks.check((int)index, (int)7) * 1L), (byte)value);
    }

    public static void nreserved1(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)3);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)RESERVED1), (long)(value.remaining() * 1));
    }

    public static void nreserved1(long struct, int index, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)RESERVED1 + Checks.check((int)index, (int)3) * 1L), (byte)value);
    }

    public static void ndelta_frame_id_minus_1(long struct, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)7);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((IntBuffer)value), (long)(struct + (long)DELTA_FRAME_ID_MINUS_1), (long)(value.remaining() * 4));
    }

    public static void ndelta_frame_id_minus_1(long struct, int index, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)DELTA_FRAME_ID_MINUS_1 + Checks.check((int)index, (int)7) * 4L), (int)value);
    }

    public static void npTileInfo(long struct, StdVideoAV1TileInfo value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PTILEINFO), (long)value.address());
    }

    public static void npQuantization(long struct, StdVideoAV1Quantization value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PQUANTIZATION), (long)value.address());
    }

    public static void npSegmentation(long struct, StdVideoAV1Segmentation value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PSEGMENTATION), (long)value.address());
    }

    public static void npLoopFilter(long struct, StdVideoAV1LoopFilter value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PLOOPFILTER), (long)value.address());
    }

    public static void npCDEF(long struct, StdVideoAV1CDEF value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PCDEF), (long)value.address());
    }

    public static void npLoopRestoration(long struct, StdVideoAV1LoopRestoration value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PLOOPRESTORATION), (long)value.address());
    }

    public static void npGlobalMotion(long struct, StdVideoAV1GlobalMotion value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PGLOBALMOTION), (long)value.address());
    }

    public static void npExtensionHeader(long struct, StdVideoEncodeAV1ExtensionHeader value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PEXTENSIONHEADER), (long)value.address());
    }

    public static void npBufferRemovalTimes(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PBUFFERREMOVALTIMES), (long)MemoryUtil.memAddress((IntBuffer)value));
    }

    public static void validate(long struct) {
        long pTileInfo = MemoryUtil.memGetAddress((long)(struct + (long)PTILEINFO));
        Checks.check((long)pTileInfo);
        StdVideoAV1TileInfo.validate(pTileInfo);
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PQUANTIZATION)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PSEGMENTATION)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PLOOPFILTER)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PCDEF)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PLOOPRESTORATION)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PGLOBALMOTION)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PEXTENSIONHEADER)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PBUFFERREMOVALTIMES)));
    }

    static {
        Struct.Layout layout = StdVideoEncodeAV1PictureInfo.__struct((Struct.Member[])new Struct.Member[]{StdVideoEncodeAV1PictureInfo.__member((int)StdVideoEncodeAV1PictureInfoFlags.SIZEOF, (int)StdVideoEncodeAV1PictureInfoFlags.ALIGNOF), StdVideoEncodeAV1PictureInfo.__member((int)4), StdVideoEncodeAV1PictureInfo.__member((int)4), StdVideoEncodeAV1PictureInfo.__member((int)4), StdVideoEncodeAV1PictureInfo.__member((int)1), StdVideoEncodeAV1PictureInfo.__member((int)1), StdVideoEncodeAV1PictureInfo.__member((int)1), StdVideoEncodeAV1PictureInfo.__member((int)1), StdVideoEncodeAV1PictureInfo.__member((int)2), StdVideoEncodeAV1PictureInfo.__member((int)2), StdVideoEncodeAV1PictureInfo.__member((int)4), StdVideoEncodeAV1PictureInfo.__member((int)4), StdVideoEncodeAV1PictureInfo.__member((int)1), StdVideoEncodeAV1PictureInfo.__member((int)1), StdVideoEncodeAV1PictureInfo.__array((int)1, (int)8), StdVideoEncodeAV1PictureInfo.__array((int)1, (int)7), StdVideoEncodeAV1PictureInfo.__array((int)1, (int)3), StdVideoEncodeAV1PictureInfo.__array((int)4, (int)7), StdVideoEncodeAV1PictureInfo.__member((int)POINTER_SIZE), StdVideoEncodeAV1PictureInfo.__member((int)POINTER_SIZE), StdVideoEncodeAV1PictureInfo.__member((int)POINTER_SIZE), StdVideoEncodeAV1PictureInfo.__member((int)POINTER_SIZE), StdVideoEncodeAV1PictureInfo.__member((int)POINTER_SIZE), StdVideoEncodeAV1PictureInfo.__member((int)POINTER_SIZE), StdVideoEncodeAV1PictureInfo.__member((int)POINTER_SIZE), StdVideoEncodeAV1PictureInfo.__member((int)POINTER_SIZE), StdVideoEncodeAV1PictureInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        FRAME_TYPE = layout.offsetof(1);
        FRAME_PRESENTATION_TIME = layout.offsetof(2);
        CURRENT_FRAME_ID = layout.offsetof(3);
        ORDER_HINT = layout.offsetof(4);
        PRIMARY_REF_FRAME = layout.offsetof(5);
        REFRESH_FRAME_FLAGS = layout.offsetof(6);
        CODED_DENOM = layout.offsetof(7);
        RENDER_WIDTH_MINUS_1 = layout.offsetof(8);
        RENDER_HEIGHT_MINUS_1 = layout.offsetof(9);
        INTERPOLATION_FILTER = layout.offsetof(10);
        TXMODE = layout.offsetof(11);
        DELTA_Q_RES = layout.offsetof(12);
        DELTA_LF_RES = layout.offsetof(13);
        REF_ORDER_HINT = layout.offsetof(14);
        REF_FRAME_IDX = layout.offsetof(15);
        RESERVED1 = layout.offsetof(16);
        DELTA_FRAME_ID_MINUS_1 = layout.offsetof(17);
        PTILEINFO = layout.offsetof(18);
        PQUANTIZATION = layout.offsetof(19);
        PSEGMENTATION = layout.offsetof(20);
        PLOOPFILTER = layout.offsetof(21);
        PCDEF = layout.offsetof(22);
        PLOOPRESTORATION = layout.offsetof(23);
        PGLOBALMOTION = layout.offsetof(24);
        PEXTENSIONHEADER = layout.offsetof(25);
        PBUFFERREMOVALTIMES = layout.offsetof(26);
    }

    public static class Buffer
    extends StructBuffer<StdVideoEncodeAV1PictureInfo, Buffer>
    implements NativeResource {
        private static final StdVideoEncodeAV1PictureInfo ELEMENT_FACTORY = StdVideoEncodeAV1PictureInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected StdVideoEncodeAV1PictureInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public StdVideoEncodeAV1PictureInfoFlags flags() {
            return StdVideoEncodeAV1PictureInfo.nflags(this.address());
        }

        @NativeType(value="StdVideoAV1FrameType")
        public int frame_type() {
            return StdVideoEncodeAV1PictureInfo.nframe_type(this.address());
        }

        @NativeType(value="uint32_t")
        public int frame_presentation_time() {
            return StdVideoEncodeAV1PictureInfo.nframe_presentation_time(this.address());
        }

        @NativeType(value="uint32_t")
        public int current_frame_id() {
            return StdVideoEncodeAV1PictureInfo.ncurrent_frame_id(this.address());
        }

        @NativeType(value="uint8_t")
        public byte order_hint() {
            return StdVideoEncodeAV1PictureInfo.norder_hint(this.address());
        }

        @NativeType(value="uint8_t")
        public byte primary_ref_frame() {
            return StdVideoEncodeAV1PictureInfo.nprimary_ref_frame(this.address());
        }

        @NativeType(value="uint8_t")
        public byte refresh_frame_flags() {
            return StdVideoEncodeAV1PictureInfo.nrefresh_frame_flags(this.address());
        }

        @NativeType(value="uint8_t")
        public byte coded_denom() {
            return StdVideoEncodeAV1PictureInfo.ncoded_denom(this.address());
        }

        @NativeType(value="uint16_t")
        public short render_width_minus_1() {
            return StdVideoEncodeAV1PictureInfo.nrender_width_minus_1(this.address());
        }

        @NativeType(value="uint16_t")
        public short render_height_minus_1() {
            return StdVideoEncodeAV1PictureInfo.nrender_height_minus_1(this.address());
        }

        @NativeType(value="StdVideoAV1InterpolationFilter")
        public int interpolation_filter() {
            return StdVideoEncodeAV1PictureInfo.ninterpolation_filter(this.address());
        }

        @NativeType(value="StdVideoAV1TxMode")
        public int TxMode() {
            return StdVideoEncodeAV1PictureInfo.nTxMode(this.address());
        }

        @NativeType(value="uint8_t")
        public byte delta_q_res() {
            return StdVideoEncodeAV1PictureInfo.ndelta_q_res(this.address());
        }

        @NativeType(value="uint8_t")
        public byte delta_lf_res() {
            return StdVideoEncodeAV1PictureInfo.ndelta_lf_res(this.address());
        }

        @NativeType(value="uint8_t[STD_VIDEO_AV1_NUM_REF_FRAMES]")
        public ByteBuffer ref_order_hint() {
            return StdVideoEncodeAV1PictureInfo.nref_order_hint(this.address());
        }

        @NativeType(value="uint8_t")
        public byte ref_order_hint(int index) {
            return StdVideoEncodeAV1PictureInfo.nref_order_hint(this.address(), index);
        }

        @NativeType(value="int8_t[STD_VIDEO_AV1_REFS_PER_FRAME]")
        public ByteBuffer ref_frame_idx() {
            return StdVideoEncodeAV1PictureInfo.nref_frame_idx(this.address());
        }

        @NativeType(value="int8_t")
        public byte ref_frame_idx(int index) {
            return StdVideoEncodeAV1PictureInfo.nref_frame_idx(this.address(), index);
        }

        @NativeType(value="uint32_t[STD_VIDEO_AV1_REFS_PER_FRAME]")
        public IntBuffer delta_frame_id_minus_1() {
            return StdVideoEncodeAV1PictureInfo.ndelta_frame_id_minus_1(this.address());
        }

        @NativeType(value="uint32_t")
        public int delta_frame_id_minus_1(int index) {
            return StdVideoEncodeAV1PictureInfo.ndelta_frame_id_minus_1(this.address(), index);
        }

        @NativeType(value="StdVideoAV1TileInfo const *")
        public StdVideoAV1TileInfo pTileInfo() {
            return StdVideoEncodeAV1PictureInfo.npTileInfo(this.address());
        }

        @NativeType(value="StdVideoAV1Quantization const *")
        public StdVideoAV1Quantization pQuantization() {
            return StdVideoEncodeAV1PictureInfo.npQuantization(this.address());
        }

        @NativeType(value="StdVideoAV1Segmentation const *")
        public StdVideoAV1Segmentation pSegmentation() {
            return StdVideoEncodeAV1PictureInfo.npSegmentation(this.address());
        }

        @NativeType(value="StdVideoAV1LoopFilter const *")
        public StdVideoAV1LoopFilter pLoopFilter() {
            return StdVideoEncodeAV1PictureInfo.npLoopFilter(this.address());
        }

        @NativeType(value="StdVideoAV1CDEF const *")
        public StdVideoAV1CDEF pCDEF() {
            return StdVideoEncodeAV1PictureInfo.npCDEF(this.address());
        }

        @NativeType(value="StdVideoAV1LoopRestoration const *")
        public StdVideoAV1LoopRestoration pLoopRestoration() {
            return StdVideoEncodeAV1PictureInfo.npLoopRestoration(this.address());
        }

        @NativeType(value="StdVideoAV1GlobalMotion const *")
        public StdVideoAV1GlobalMotion pGlobalMotion() {
            return StdVideoEncodeAV1PictureInfo.npGlobalMotion(this.address());
        }

        @NativeType(value="StdVideoEncodeAV1ExtensionHeader const *")
        public StdVideoEncodeAV1ExtensionHeader pExtensionHeader() {
            return StdVideoEncodeAV1PictureInfo.npExtensionHeader(this.address());
        }

        @NativeType(value="uint32_t const *")
        public IntBuffer pBufferRemovalTimes(int capacity) {
            return StdVideoEncodeAV1PictureInfo.npBufferRemovalTimes(this.address(), capacity);
        }

        public Buffer flags(StdVideoEncodeAV1PictureInfoFlags value) {
            StdVideoEncodeAV1PictureInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer flags(Consumer<StdVideoEncodeAV1PictureInfoFlags> consumer) {
            consumer.accept(this.flags());
            return this;
        }

        public Buffer frame_type(@NativeType(value="StdVideoAV1FrameType") int value) {
            StdVideoEncodeAV1PictureInfo.nframe_type(this.address(), value);
            return this;
        }

        public Buffer frame_presentation_time(@NativeType(value="uint32_t") int value) {
            StdVideoEncodeAV1PictureInfo.nframe_presentation_time(this.address(), value);
            return this;
        }

        public Buffer current_frame_id(@NativeType(value="uint32_t") int value) {
            StdVideoEncodeAV1PictureInfo.ncurrent_frame_id(this.address(), value);
            return this;
        }

        public Buffer order_hint(@NativeType(value="uint8_t") byte value) {
            StdVideoEncodeAV1PictureInfo.norder_hint(this.address(), value);
            return this;
        }

        public Buffer primary_ref_frame(@NativeType(value="uint8_t") byte value) {
            StdVideoEncodeAV1PictureInfo.nprimary_ref_frame(this.address(), value);
            return this;
        }

        public Buffer refresh_frame_flags(@NativeType(value="uint8_t") byte value) {
            StdVideoEncodeAV1PictureInfo.nrefresh_frame_flags(this.address(), value);
            return this;
        }

        public Buffer coded_denom(@NativeType(value="uint8_t") byte value) {
            StdVideoEncodeAV1PictureInfo.ncoded_denom(this.address(), value);
            return this;
        }

        public Buffer render_width_minus_1(@NativeType(value="uint16_t") short value) {
            StdVideoEncodeAV1PictureInfo.nrender_width_minus_1(this.address(), value);
            return this;
        }

        public Buffer render_height_minus_1(@NativeType(value="uint16_t") short value) {
            StdVideoEncodeAV1PictureInfo.nrender_height_minus_1(this.address(), value);
            return this;
        }

        public Buffer interpolation_filter(@NativeType(value="StdVideoAV1InterpolationFilter") int value) {
            StdVideoEncodeAV1PictureInfo.ninterpolation_filter(this.address(), value);
            return this;
        }

        public Buffer TxMode(@NativeType(value="StdVideoAV1TxMode") int value) {
            StdVideoEncodeAV1PictureInfo.nTxMode(this.address(), value);
            return this;
        }

        public Buffer delta_q_res(@NativeType(value="uint8_t") byte value) {
            StdVideoEncodeAV1PictureInfo.ndelta_q_res(this.address(), value);
            return this;
        }

        public Buffer delta_lf_res(@NativeType(value="uint8_t") byte value) {
            StdVideoEncodeAV1PictureInfo.ndelta_lf_res(this.address(), value);
            return this;
        }

        public Buffer ref_order_hint(@NativeType(value="uint8_t[STD_VIDEO_AV1_NUM_REF_FRAMES]") ByteBuffer value) {
            StdVideoEncodeAV1PictureInfo.nref_order_hint(this.address(), value);
            return this;
        }

        public Buffer ref_order_hint(int index, @NativeType(value="uint8_t") byte value) {
            StdVideoEncodeAV1PictureInfo.nref_order_hint(this.address(), index, value);
            return this;
        }

        public Buffer ref_frame_idx(@NativeType(value="int8_t[STD_VIDEO_AV1_REFS_PER_FRAME]") ByteBuffer value) {
            StdVideoEncodeAV1PictureInfo.nref_frame_idx(this.address(), value);
            return this;
        }

        public Buffer ref_frame_idx(int index, @NativeType(value="int8_t") byte value) {
            StdVideoEncodeAV1PictureInfo.nref_frame_idx(this.address(), index, value);
            return this;
        }

        public Buffer delta_frame_id_minus_1(@NativeType(value="uint32_t[STD_VIDEO_AV1_REFS_PER_FRAME]") IntBuffer value) {
            StdVideoEncodeAV1PictureInfo.ndelta_frame_id_minus_1(this.address(), value);
            return this;
        }

        public Buffer delta_frame_id_minus_1(int index, @NativeType(value="uint32_t") int value) {
            StdVideoEncodeAV1PictureInfo.ndelta_frame_id_minus_1(this.address(), index, value);
            return this;
        }

        public Buffer pTileInfo(@NativeType(value="StdVideoAV1TileInfo const *") StdVideoAV1TileInfo value) {
            StdVideoEncodeAV1PictureInfo.npTileInfo(this.address(), value);
            return this;
        }

        public Buffer pQuantization(@NativeType(value="StdVideoAV1Quantization const *") StdVideoAV1Quantization value) {
            StdVideoEncodeAV1PictureInfo.npQuantization(this.address(), value);
            return this;
        }

        public Buffer pSegmentation(@NativeType(value="StdVideoAV1Segmentation const *") StdVideoAV1Segmentation value) {
            StdVideoEncodeAV1PictureInfo.npSegmentation(this.address(), value);
            return this;
        }

        public Buffer pLoopFilter(@NativeType(value="StdVideoAV1LoopFilter const *") StdVideoAV1LoopFilter value) {
            StdVideoEncodeAV1PictureInfo.npLoopFilter(this.address(), value);
            return this;
        }

        public Buffer pCDEF(@NativeType(value="StdVideoAV1CDEF const *") StdVideoAV1CDEF value) {
            StdVideoEncodeAV1PictureInfo.npCDEF(this.address(), value);
            return this;
        }

        public Buffer pLoopRestoration(@NativeType(value="StdVideoAV1LoopRestoration const *") StdVideoAV1LoopRestoration value) {
            StdVideoEncodeAV1PictureInfo.npLoopRestoration(this.address(), value);
            return this;
        }

        public Buffer pGlobalMotion(@NativeType(value="StdVideoAV1GlobalMotion const *") StdVideoAV1GlobalMotion value) {
            StdVideoEncodeAV1PictureInfo.npGlobalMotion(this.address(), value);
            return this;
        }

        public Buffer pExtensionHeader(@NativeType(value="StdVideoEncodeAV1ExtensionHeader const *") StdVideoEncodeAV1ExtensionHeader value) {
            StdVideoEncodeAV1PictureInfo.npExtensionHeader(this.address(), value);
            return this;
        }

        public Buffer pBufferRemovalTimes(@NativeType(value="uint32_t const *") IntBuffer value) {
            StdVideoEncodeAV1PictureInfo.npBufferRemovalTimes(this.address(), value);
            return this;
        }
    }
}

