/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan.video;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.video.StdVideoEncodeAV1ExtensionHeader;
import org.lwjgl.vulkan.video.StdVideoEncodeAV1ReferenceInfoFlags;

public class StdVideoEncodeAV1ReferenceInfo
extends Struct<StdVideoEncodeAV1ReferenceInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int REFFRAMEID;
    public static final int FRAME_TYPE;
    public static final int ORDERHINT;
    public static final int RESERVED1;
    public static final int PEXTENSIONHEADER;

    protected StdVideoEncodeAV1ReferenceInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected StdVideoEncodeAV1ReferenceInfo create(long address, @Nullable ByteBuffer container) {
        return new StdVideoEncodeAV1ReferenceInfo(address, container);
    }

    public StdVideoEncodeAV1ReferenceInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), StdVideoEncodeAV1ReferenceInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public StdVideoEncodeAV1ReferenceInfoFlags flags() {
        return StdVideoEncodeAV1ReferenceInfo.nflags(this.address());
    }

    @NativeType(value="uint32_t")
    public int RefFrameId() {
        return StdVideoEncodeAV1ReferenceInfo.nRefFrameId(this.address());
    }

    @NativeType(value="StdVideoAV1FrameType")
    public int frame_type() {
        return StdVideoEncodeAV1ReferenceInfo.nframe_type(this.address());
    }

    @NativeType(value="uint8_t")
    public byte OrderHint() {
        return StdVideoEncodeAV1ReferenceInfo.nOrderHint(this.address());
    }

    @NativeType(value="StdVideoEncodeAV1ExtensionHeader const *")
    public StdVideoEncodeAV1ExtensionHeader pExtensionHeader() {
        return StdVideoEncodeAV1ReferenceInfo.npExtensionHeader(this.address());
    }

    public StdVideoEncodeAV1ReferenceInfo flags(StdVideoEncodeAV1ReferenceInfoFlags value) {
        StdVideoEncodeAV1ReferenceInfo.nflags(this.address(), value);
        return this;
    }

    public StdVideoEncodeAV1ReferenceInfo flags(Consumer<StdVideoEncodeAV1ReferenceInfoFlags> consumer) {
        consumer.accept(this.flags());
        return this;
    }

    public StdVideoEncodeAV1ReferenceInfo RefFrameId(@NativeType(value="uint32_t") int value) {
        StdVideoEncodeAV1ReferenceInfo.nRefFrameId(this.address(), value);
        return this;
    }

    public StdVideoEncodeAV1ReferenceInfo frame_type(@NativeType(value="StdVideoAV1FrameType") int value) {
        StdVideoEncodeAV1ReferenceInfo.nframe_type(this.address(), value);
        return this;
    }

    public StdVideoEncodeAV1ReferenceInfo OrderHint(@NativeType(value="uint8_t") byte value) {
        StdVideoEncodeAV1ReferenceInfo.nOrderHint(this.address(), value);
        return this;
    }

    public StdVideoEncodeAV1ReferenceInfo pExtensionHeader(@NativeType(value="StdVideoEncodeAV1ExtensionHeader const *") StdVideoEncodeAV1ExtensionHeader value) {
        StdVideoEncodeAV1ReferenceInfo.npExtensionHeader(this.address(), value);
        return this;
    }

    public StdVideoEncodeAV1ReferenceInfo set(StdVideoEncodeAV1ReferenceInfoFlags flags, int RefFrameId, int frame_type, byte OrderHint, StdVideoEncodeAV1ExtensionHeader pExtensionHeader) {
        this.flags(flags);
        this.RefFrameId(RefFrameId);
        this.frame_type(frame_type);
        this.OrderHint(OrderHint);
        this.pExtensionHeader(pExtensionHeader);
        return this;
    }

    public StdVideoEncodeAV1ReferenceInfo set(StdVideoEncodeAV1ReferenceInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static StdVideoEncodeAV1ReferenceInfo malloc() {
        return new StdVideoEncodeAV1ReferenceInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static StdVideoEncodeAV1ReferenceInfo calloc() {
        return new StdVideoEncodeAV1ReferenceInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static StdVideoEncodeAV1ReferenceInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new StdVideoEncodeAV1ReferenceInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static StdVideoEncodeAV1ReferenceInfo create(long address) {
        return new StdVideoEncodeAV1ReferenceInfo(address, null);
    }

    public static @Nullable StdVideoEncodeAV1ReferenceInfo createSafe(long address) {
        return address == 0L ? null : new StdVideoEncodeAV1ReferenceInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)StdVideoEncodeAV1ReferenceInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = StdVideoEncodeAV1ReferenceInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static StdVideoEncodeAV1ReferenceInfo malloc(MemoryStack stack) {
        return new StdVideoEncodeAV1ReferenceInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static StdVideoEncodeAV1ReferenceInfo calloc(MemoryStack stack) {
        return new StdVideoEncodeAV1ReferenceInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static StdVideoEncodeAV1ReferenceInfoFlags nflags(long struct) {
        return StdVideoEncodeAV1ReferenceInfoFlags.create(struct + (long)FLAGS);
    }

    public static int nRefFrameId(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)REFFRAMEID));
    }

    public static int nframe_type(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FRAME_TYPE));
    }

    public static byte nOrderHint(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)ORDERHINT));
    }

    public static ByteBuffer nreserved1(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)RESERVED1), (int)3);
    }

    public static byte nreserved1(long struct, int index) {
        return MemoryUtil.memGetByte((long)(struct + (long)RESERVED1 + Checks.check((int)index, (int)3) * 1L));
    }

    public static StdVideoEncodeAV1ExtensionHeader npExtensionHeader(long struct) {
        return StdVideoEncodeAV1ExtensionHeader.create(MemoryUtil.memGetAddress((long)(struct + (long)PEXTENSIONHEADER)));
    }

    public static void nflags(long struct, StdVideoEncodeAV1ReferenceInfoFlags value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)FLAGS), (long)StdVideoEncodeAV1ReferenceInfoFlags.SIZEOF);
    }

    public static void nRefFrameId(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)REFFRAMEID), (int)value);
    }

    public static void nframe_type(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)FRAME_TYPE), (int)value);
    }

    public static void nOrderHint(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)ORDERHINT), (byte)value);
    }

    public static void nreserved1(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)3);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)RESERVED1), (long)(value.remaining() * 1));
    }

    public static void nreserved1(long struct, int index, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)RESERVED1 + Checks.check((int)index, (int)3) * 1L), (byte)value);
    }

    public static void npExtensionHeader(long struct, StdVideoEncodeAV1ExtensionHeader value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PEXTENSIONHEADER), (long)value.address());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PEXTENSIONHEADER)));
    }

    static {
        Struct.Layout layout = StdVideoEncodeAV1ReferenceInfo.__struct((Struct.Member[])new Struct.Member[]{StdVideoEncodeAV1ReferenceInfo.__member((int)StdVideoEncodeAV1ReferenceInfoFlags.SIZEOF, (int)StdVideoEncodeAV1ReferenceInfoFlags.ALIGNOF), StdVideoEncodeAV1ReferenceInfo.__member((int)4), StdVideoEncodeAV1ReferenceInfo.__member((int)4), StdVideoEncodeAV1ReferenceInfo.__member((int)1), StdVideoEncodeAV1ReferenceInfo.__array((int)1, (int)3), StdVideoEncodeAV1ReferenceInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        REFFRAMEID = layout.offsetof(1);
        FRAME_TYPE = layout.offsetof(2);
        ORDERHINT = layout.offsetof(3);
        RESERVED1 = layout.offsetof(4);
        PEXTENSIONHEADER = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<StdVideoEncodeAV1ReferenceInfo, Buffer>
    implements NativeResource {
        private static final StdVideoEncodeAV1ReferenceInfo ELEMENT_FACTORY = StdVideoEncodeAV1ReferenceInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected StdVideoEncodeAV1ReferenceInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public StdVideoEncodeAV1ReferenceInfoFlags flags() {
            return StdVideoEncodeAV1ReferenceInfo.nflags(this.address());
        }

        @NativeType(value="uint32_t")
        public int RefFrameId() {
            return StdVideoEncodeAV1ReferenceInfo.nRefFrameId(this.address());
        }

        @NativeType(value="StdVideoAV1FrameType")
        public int frame_type() {
            return StdVideoEncodeAV1ReferenceInfo.nframe_type(this.address());
        }

        @NativeType(value="uint8_t")
        public byte OrderHint() {
            return StdVideoEncodeAV1ReferenceInfo.nOrderHint(this.address());
        }

        @NativeType(value="StdVideoEncodeAV1ExtensionHeader const *")
        public StdVideoEncodeAV1ExtensionHeader pExtensionHeader() {
            return StdVideoEncodeAV1ReferenceInfo.npExtensionHeader(this.address());
        }

        public Buffer flags(StdVideoEncodeAV1ReferenceInfoFlags value) {
            StdVideoEncodeAV1ReferenceInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer flags(Consumer<StdVideoEncodeAV1ReferenceInfoFlags> consumer) {
            consumer.accept(this.flags());
            return this;
        }

        public Buffer RefFrameId(@NativeType(value="uint32_t") int value) {
            StdVideoEncodeAV1ReferenceInfo.nRefFrameId(this.address(), value);
            return this;
        }

        public Buffer frame_type(@NativeType(value="StdVideoAV1FrameType") int value) {
            StdVideoEncodeAV1ReferenceInfo.nframe_type(this.address(), value);
            return this;
        }

        public Buffer OrderHint(@NativeType(value="uint8_t") byte value) {
            StdVideoEncodeAV1ReferenceInfo.nOrderHint(this.address(), value);
            return this;
        }

        public Buffer pExtensionHeader(@NativeType(value="StdVideoEncodeAV1ExtensionHeader const *") StdVideoEncodeAV1ExtensionHeader value) {
            StdVideoEncodeAV1ReferenceInfo.npExtensionHeader(this.address(), value);
            return this;
        }
    }
}

