/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan.video;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.video.StdVideoEncodeH264RefListModEntry;
import org.lwjgl.vulkan.video.StdVideoEncodeH264RefPicMarkingEntry;
import org.lwjgl.vulkan.video.StdVideoEncodeH264ReferenceListsInfoFlags;

public class StdVideoEncodeH264ReferenceListsInfo
extends Struct<StdVideoEncodeH264ReferenceListsInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int NUM_REF_IDX_L0_ACTIVE_MINUS1;
    public static final int NUM_REF_IDX_L1_ACTIVE_MINUS1;
    public static final int REFPICLIST0;
    public static final int REFPICLIST1;
    public static final int REFLIST0MODOPCOUNT;
    public static final int REFLIST1MODOPCOUNT;
    public static final int REFPICMARKINGOPCOUNT;
    public static final int RESERVED1;
    public static final int PREFLIST0MODOPERATIONS;
    public static final int PREFLIST1MODOPERATIONS;
    public static final int PREFPICMARKINGOPERATIONS;

    protected StdVideoEncodeH264ReferenceListsInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected StdVideoEncodeH264ReferenceListsInfo create(long address, @Nullable ByteBuffer container) {
        return new StdVideoEncodeH264ReferenceListsInfo(address, container);
    }

    public StdVideoEncodeH264ReferenceListsInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), StdVideoEncodeH264ReferenceListsInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public StdVideoEncodeH264ReferenceListsInfoFlags flags() {
        return StdVideoEncodeH264ReferenceListsInfo.nflags(this.address());
    }

    @NativeType(value="uint8_t")
    public byte num_ref_idx_l0_active_minus1() {
        return StdVideoEncodeH264ReferenceListsInfo.nnum_ref_idx_l0_active_minus1(this.address());
    }

    @NativeType(value="uint8_t")
    public byte num_ref_idx_l1_active_minus1() {
        return StdVideoEncodeH264ReferenceListsInfo.nnum_ref_idx_l1_active_minus1(this.address());
    }

    @NativeType(value="uint8_t[STD_VIDEO_H264_MAX_NUM_LIST_REF]")
    public ByteBuffer RefPicList0() {
        return StdVideoEncodeH264ReferenceListsInfo.nRefPicList0(this.address());
    }

    @NativeType(value="uint8_t")
    public byte RefPicList0(int index) {
        return StdVideoEncodeH264ReferenceListsInfo.nRefPicList0(this.address(), index);
    }

    @NativeType(value="uint8_t[STD_VIDEO_H264_MAX_NUM_LIST_REF]")
    public ByteBuffer RefPicList1() {
        return StdVideoEncodeH264ReferenceListsInfo.nRefPicList1(this.address());
    }

    @NativeType(value="uint8_t")
    public byte RefPicList1(int index) {
        return StdVideoEncodeH264ReferenceListsInfo.nRefPicList1(this.address(), index);
    }

    @NativeType(value="uint8_t")
    public byte refList0ModOpCount() {
        return StdVideoEncodeH264ReferenceListsInfo.nrefList0ModOpCount(this.address());
    }

    @NativeType(value="uint8_t")
    public byte refList1ModOpCount() {
        return StdVideoEncodeH264ReferenceListsInfo.nrefList1ModOpCount(this.address());
    }

    @NativeType(value="uint8_t")
    public byte refPicMarkingOpCount() {
        return StdVideoEncodeH264ReferenceListsInfo.nrefPicMarkingOpCount(this.address());
    }

    @NativeType(value="StdVideoEncodeH264RefListModEntry const *")
    public @Nullable StdVideoEncodeH264RefListModEntry.Buffer pRefList0ModOperations() {
        return StdVideoEncodeH264ReferenceListsInfo.npRefList0ModOperations(this.address());
    }

    @NativeType(value="StdVideoEncodeH264RefListModEntry const *")
    public @Nullable StdVideoEncodeH264RefListModEntry.Buffer pRefList1ModOperations() {
        return StdVideoEncodeH264ReferenceListsInfo.npRefList1ModOperations(this.address());
    }

    @NativeType(value="StdVideoEncodeH264RefPicMarkingEntry const *")
    public StdVideoEncodeH264RefPicMarkingEntry.Buffer pRefPicMarkingOperations() {
        return StdVideoEncodeH264ReferenceListsInfo.npRefPicMarkingOperations(this.address());
    }

    public StdVideoEncodeH264ReferenceListsInfo flags(StdVideoEncodeH264ReferenceListsInfoFlags value) {
        StdVideoEncodeH264ReferenceListsInfo.nflags(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264ReferenceListsInfo flags(Consumer<StdVideoEncodeH264ReferenceListsInfoFlags> consumer) {
        consumer.accept(this.flags());
        return this;
    }

    public StdVideoEncodeH264ReferenceListsInfo num_ref_idx_l0_active_minus1(@NativeType(value="uint8_t") byte value) {
        StdVideoEncodeH264ReferenceListsInfo.nnum_ref_idx_l0_active_minus1(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264ReferenceListsInfo num_ref_idx_l1_active_minus1(@NativeType(value="uint8_t") byte value) {
        StdVideoEncodeH264ReferenceListsInfo.nnum_ref_idx_l1_active_minus1(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264ReferenceListsInfo RefPicList0(@NativeType(value="uint8_t[STD_VIDEO_H264_MAX_NUM_LIST_REF]") ByteBuffer value) {
        StdVideoEncodeH264ReferenceListsInfo.nRefPicList0(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264ReferenceListsInfo RefPicList0(int index, @NativeType(value="uint8_t") byte value) {
        StdVideoEncodeH264ReferenceListsInfo.nRefPicList0(this.address(), index, value);
        return this;
    }

    public StdVideoEncodeH264ReferenceListsInfo RefPicList1(@NativeType(value="uint8_t[STD_VIDEO_H264_MAX_NUM_LIST_REF]") ByteBuffer value) {
        StdVideoEncodeH264ReferenceListsInfo.nRefPicList1(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264ReferenceListsInfo RefPicList1(int index, @NativeType(value="uint8_t") byte value) {
        StdVideoEncodeH264ReferenceListsInfo.nRefPicList1(this.address(), index, value);
        return this;
    }

    public StdVideoEncodeH264ReferenceListsInfo refList0ModOpCount(@NativeType(value="uint8_t") byte value) {
        StdVideoEncodeH264ReferenceListsInfo.nrefList0ModOpCount(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264ReferenceListsInfo refList1ModOpCount(@NativeType(value="uint8_t") byte value) {
        StdVideoEncodeH264ReferenceListsInfo.nrefList1ModOpCount(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264ReferenceListsInfo pRefList0ModOperations(@NativeType(value="StdVideoEncodeH264RefListModEntry const *") @Nullable StdVideoEncodeH264RefListModEntry.Buffer value) {
        StdVideoEncodeH264ReferenceListsInfo.npRefList0ModOperations(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264ReferenceListsInfo pRefList1ModOperations(@NativeType(value="StdVideoEncodeH264RefListModEntry const *") @Nullable StdVideoEncodeH264RefListModEntry.Buffer value) {
        StdVideoEncodeH264ReferenceListsInfo.npRefList1ModOperations(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264ReferenceListsInfo pRefPicMarkingOperations(@NativeType(value="StdVideoEncodeH264RefPicMarkingEntry const *") StdVideoEncodeH264RefPicMarkingEntry.Buffer value) {
        StdVideoEncodeH264ReferenceListsInfo.npRefPicMarkingOperations(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264ReferenceListsInfo set(StdVideoEncodeH264ReferenceListsInfoFlags flags, byte num_ref_idx_l0_active_minus1, byte num_ref_idx_l1_active_minus1, ByteBuffer RefPicList0, ByteBuffer RefPicList1, byte refList0ModOpCount, byte refList1ModOpCount, @Nullable StdVideoEncodeH264RefListModEntry.Buffer pRefList0ModOperations, @Nullable StdVideoEncodeH264RefListModEntry.Buffer pRefList1ModOperations, StdVideoEncodeH264RefPicMarkingEntry.Buffer pRefPicMarkingOperations) {
        this.flags(flags);
        this.num_ref_idx_l0_active_minus1(num_ref_idx_l0_active_minus1);
        this.num_ref_idx_l1_active_minus1(num_ref_idx_l1_active_minus1);
        this.RefPicList0(RefPicList0);
        this.RefPicList1(RefPicList1);
        this.refList0ModOpCount(refList0ModOpCount);
        this.refList1ModOpCount(refList1ModOpCount);
        this.pRefList0ModOperations(pRefList0ModOperations);
        this.pRefList1ModOperations(pRefList1ModOperations);
        this.pRefPicMarkingOperations(pRefPicMarkingOperations);
        return this;
    }

    public StdVideoEncodeH264ReferenceListsInfo set(StdVideoEncodeH264ReferenceListsInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static StdVideoEncodeH264ReferenceListsInfo malloc() {
        return new StdVideoEncodeH264ReferenceListsInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static StdVideoEncodeH264ReferenceListsInfo calloc() {
        return new StdVideoEncodeH264ReferenceListsInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static StdVideoEncodeH264ReferenceListsInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new StdVideoEncodeH264ReferenceListsInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static StdVideoEncodeH264ReferenceListsInfo create(long address) {
        return new StdVideoEncodeH264ReferenceListsInfo(address, null);
    }

    public static @Nullable StdVideoEncodeH264ReferenceListsInfo createSafe(long address) {
        return address == 0L ? null : new StdVideoEncodeH264ReferenceListsInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)StdVideoEncodeH264ReferenceListsInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = StdVideoEncodeH264ReferenceListsInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static StdVideoEncodeH264ReferenceListsInfo malloc(MemoryStack stack) {
        return new StdVideoEncodeH264ReferenceListsInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static StdVideoEncodeH264ReferenceListsInfo calloc(MemoryStack stack) {
        return new StdVideoEncodeH264ReferenceListsInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static StdVideoEncodeH264ReferenceListsInfoFlags nflags(long struct) {
        return StdVideoEncodeH264ReferenceListsInfoFlags.create(struct + (long)FLAGS);
    }

    public static byte nnum_ref_idx_l0_active_minus1(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)NUM_REF_IDX_L0_ACTIVE_MINUS1));
    }

    public static byte nnum_ref_idx_l1_active_minus1(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)NUM_REF_IDX_L1_ACTIVE_MINUS1));
    }

    public static ByteBuffer nRefPicList0(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)REFPICLIST0), (int)32);
    }

    public static byte nRefPicList0(long struct, int index) {
        return MemoryUtil.memGetByte((long)(struct + (long)REFPICLIST0 + Checks.check((int)index, (int)32) * 1L));
    }

    public static ByteBuffer nRefPicList1(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)REFPICLIST1), (int)32);
    }

    public static byte nRefPicList1(long struct, int index) {
        return MemoryUtil.memGetByte((long)(struct + (long)REFPICLIST1 + Checks.check((int)index, (int)32) * 1L));
    }

    public static byte nrefList0ModOpCount(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)REFLIST0MODOPCOUNT));
    }

    public static byte nrefList1ModOpCount(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)REFLIST1MODOPCOUNT));
    }

    public static byte nrefPicMarkingOpCount(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)REFPICMARKINGOPCOUNT));
    }

    public static ByteBuffer nreserved1(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)RESERVED1), (int)7);
    }

    public static byte nreserved1(long struct, int index) {
        return MemoryUtil.memGetByte((long)(struct + (long)RESERVED1 + Checks.check((int)index, (int)7) * 1L));
    }

    public static @Nullable StdVideoEncodeH264RefListModEntry.Buffer npRefList0ModOperations(long struct) {
        return StdVideoEncodeH264RefListModEntry.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PREFLIST0MODOPERATIONS)), Byte.toUnsignedInt(StdVideoEncodeH264ReferenceListsInfo.nrefList0ModOpCount(struct)));
    }

    public static @Nullable StdVideoEncodeH264RefListModEntry.Buffer npRefList1ModOperations(long struct) {
        return StdVideoEncodeH264RefListModEntry.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PREFLIST1MODOPERATIONS)), Byte.toUnsignedInt(StdVideoEncodeH264ReferenceListsInfo.nrefList1ModOpCount(struct)));
    }

    public static StdVideoEncodeH264RefPicMarkingEntry.Buffer npRefPicMarkingOperations(long struct) {
        return StdVideoEncodeH264RefPicMarkingEntry.create(MemoryUtil.memGetAddress((long)(struct + (long)PREFPICMARKINGOPERATIONS)), Byte.toUnsignedInt(StdVideoEncodeH264ReferenceListsInfo.nrefPicMarkingOpCount(struct)));
    }

    public static void nflags(long struct, StdVideoEncodeH264ReferenceListsInfoFlags value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)FLAGS), (long)StdVideoEncodeH264ReferenceListsInfoFlags.SIZEOF);
    }

    public static void nnum_ref_idx_l0_active_minus1(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)NUM_REF_IDX_L0_ACTIVE_MINUS1), (byte)value);
    }

    public static void nnum_ref_idx_l1_active_minus1(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)NUM_REF_IDX_L1_ACTIVE_MINUS1), (byte)value);
    }

    public static void nRefPicList0(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)32);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)REFPICLIST0), (long)(value.remaining() * 1));
    }

    public static void nRefPicList0(long struct, int index, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)REFPICLIST0 + Checks.check((int)index, (int)32) * 1L), (byte)value);
    }

    public static void nRefPicList1(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)32);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)REFPICLIST1), (long)(value.remaining() * 1));
    }

    public static void nRefPicList1(long struct, int index, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)REFPICLIST1 + Checks.check((int)index, (int)32) * 1L), (byte)value);
    }

    public static void nrefList0ModOpCount(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)REFLIST0MODOPCOUNT), (byte)value);
    }

    public static void nrefList1ModOpCount(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)REFLIST1MODOPCOUNT), (byte)value);
    }

    public static void nrefPicMarkingOpCount(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)REFPICMARKINGOPCOUNT), (byte)value);
    }

    public static void nreserved1(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)7);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)RESERVED1), (long)(value.remaining() * 1));
    }

    public static void nreserved1(long struct, int index, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)RESERVED1 + Checks.check((int)index, (int)7) * 1L), (byte)value);
    }

    public static void npRefList0ModOperations(long struct, @Nullable StdVideoEncodeH264RefListModEntry.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PREFLIST0MODOPERATIONS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        StdVideoEncodeH264ReferenceListsInfo.nrefList0ModOpCount(struct, value == null ? (byte)0 : (byte)value.remaining());
    }

    public static void npRefList1ModOperations(long struct, @Nullable StdVideoEncodeH264RefListModEntry.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PREFLIST1MODOPERATIONS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        StdVideoEncodeH264ReferenceListsInfo.nrefList1ModOpCount(struct, value == null ? (byte)0 : (byte)value.remaining());
    }

    public static void npRefPicMarkingOperations(long struct, StdVideoEncodeH264RefPicMarkingEntry.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PREFPICMARKINGOPERATIONS), (long)value.address());
        StdVideoEncodeH264ReferenceListsInfo.nrefPicMarkingOpCount(struct, (byte)value.remaining());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PREFPICMARKINGOPERATIONS)));
    }

    static {
        Struct.Layout layout = StdVideoEncodeH264ReferenceListsInfo.__struct((Struct.Member[])new Struct.Member[]{StdVideoEncodeH264ReferenceListsInfo.__member((int)StdVideoEncodeH264ReferenceListsInfoFlags.SIZEOF, (int)StdVideoEncodeH264ReferenceListsInfoFlags.ALIGNOF), StdVideoEncodeH264ReferenceListsInfo.__member((int)1), StdVideoEncodeH264ReferenceListsInfo.__member((int)1), StdVideoEncodeH264ReferenceListsInfo.__array((int)1, (int)32), StdVideoEncodeH264ReferenceListsInfo.__array((int)1, (int)32), StdVideoEncodeH264ReferenceListsInfo.__member((int)1), StdVideoEncodeH264ReferenceListsInfo.__member((int)1), StdVideoEncodeH264ReferenceListsInfo.__member((int)1), StdVideoEncodeH264ReferenceListsInfo.__array((int)1, (int)7), StdVideoEncodeH264ReferenceListsInfo.__member((int)POINTER_SIZE), StdVideoEncodeH264ReferenceListsInfo.__member((int)POINTER_SIZE), StdVideoEncodeH264ReferenceListsInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        NUM_REF_IDX_L0_ACTIVE_MINUS1 = layout.offsetof(1);
        NUM_REF_IDX_L1_ACTIVE_MINUS1 = layout.offsetof(2);
        REFPICLIST0 = layout.offsetof(3);
        REFPICLIST1 = layout.offsetof(4);
        REFLIST0MODOPCOUNT = layout.offsetof(5);
        REFLIST1MODOPCOUNT = layout.offsetof(6);
        REFPICMARKINGOPCOUNT = layout.offsetof(7);
        RESERVED1 = layout.offsetof(8);
        PREFLIST0MODOPERATIONS = layout.offsetof(9);
        PREFLIST1MODOPERATIONS = layout.offsetof(10);
        PREFPICMARKINGOPERATIONS = layout.offsetof(11);
    }

    public static class Buffer
    extends StructBuffer<StdVideoEncodeH264ReferenceListsInfo, Buffer>
    implements NativeResource {
        private static final StdVideoEncodeH264ReferenceListsInfo ELEMENT_FACTORY = StdVideoEncodeH264ReferenceListsInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected StdVideoEncodeH264ReferenceListsInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public StdVideoEncodeH264ReferenceListsInfoFlags flags() {
            return StdVideoEncodeH264ReferenceListsInfo.nflags(this.address());
        }

        @NativeType(value="uint8_t")
        public byte num_ref_idx_l0_active_minus1() {
            return StdVideoEncodeH264ReferenceListsInfo.nnum_ref_idx_l0_active_minus1(this.address());
        }

        @NativeType(value="uint8_t")
        public byte num_ref_idx_l1_active_minus1() {
            return StdVideoEncodeH264ReferenceListsInfo.nnum_ref_idx_l1_active_minus1(this.address());
        }

        @NativeType(value="uint8_t[STD_VIDEO_H264_MAX_NUM_LIST_REF]")
        public ByteBuffer RefPicList0() {
            return StdVideoEncodeH264ReferenceListsInfo.nRefPicList0(this.address());
        }

        @NativeType(value="uint8_t")
        public byte RefPicList0(int index) {
            return StdVideoEncodeH264ReferenceListsInfo.nRefPicList0(this.address(), index);
        }

        @NativeType(value="uint8_t[STD_VIDEO_H264_MAX_NUM_LIST_REF]")
        public ByteBuffer RefPicList1() {
            return StdVideoEncodeH264ReferenceListsInfo.nRefPicList1(this.address());
        }

        @NativeType(value="uint8_t")
        public byte RefPicList1(int index) {
            return StdVideoEncodeH264ReferenceListsInfo.nRefPicList1(this.address(), index);
        }

        @NativeType(value="uint8_t")
        public byte refList0ModOpCount() {
            return StdVideoEncodeH264ReferenceListsInfo.nrefList0ModOpCount(this.address());
        }

        @NativeType(value="uint8_t")
        public byte refList1ModOpCount() {
            return StdVideoEncodeH264ReferenceListsInfo.nrefList1ModOpCount(this.address());
        }

        @NativeType(value="uint8_t")
        public byte refPicMarkingOpCount() {
            return StdVideoEncodeH264ReferenceListsInfo.nrefPicMarkingOpCount(this.address());
        }

        @NativeType(value="StdVideoEncodeH264RefListModEntry const *")
        public @Nullable StdVideoEncodeH264RefListModEntry.Buffer pRefList0ModOperations() {
            return StdVideoEncodeH264ReferenceListsInfo.npRefList0ModOperations(this.address());
        }

        @NativeType(value="StdVideoEncodeH264RefListModEntry const *")
        public @Nullable StdVideoEncodeH264RefListModEntry.Buffer pRefList1ModOperations() {
            return StdVideoEncodeH264ReferenceListsInfo.npRefList1ModOperations(this.address());
        }

        @NativeType(value="StdVideoEncodeH264RefPicMarkingEntry const *")
        public StdVideoEncodeH264RefPicMarkingEntry.Buffer pRefPicMarkingOperations() {
            return StdVideoEncodeH264ReferenceListsInfo.npRefPicMarkingOperations(this.address());
        }

        public Buffer flags(StdVideoEncodeH264ReferenceListsInfoFlags value) {
            StdVideoEncodeH264ReferenceListsInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer flags(Consumer<StdVideoEncodeH264ReferenceListsInfoFlags> consumer) {
            consumer.accept(this.flags());
            return this;
        }

        public Buffer num_ref_idx_l0_active_minus1(@NativeType(value="uint8_t") byte value) {
            StdVideoEncodeH264ReferenceListsInfo.nnum_ref_idx_l0_active_minus1(this.address(), value);
            return this;
        }

        public Buffer num_ref_idx_l1_active_minus1(@NativeType(value="uint8_t") byte value) {
            StdVideoEncodeH264ReferenceListsInfo.nnum_ref_idx_l1_active_minus1(this.address(), value);
            return this;
        }

        public Buffer RefPicList0(@NativeType(value="uint8_t[STD_VIDEO_H264_MAX_NUM_LIST_REF]") ByteBuffer value) {
            StdVideoEncodeH264ReferenceListsInfo.nRefPicList0(this.address(), value);
            return this;
        }

        public Buffer RefPicList0(int index, @NativeType(value="uint8_t") byte value) {
            StdVideoEncodeH264ReferenceListsInfo.nRefPicList0(this.address(), index, value);
            return this;
        }

        public Buffer RefPicList1(@NativeType(value="uint8_t[STD_VIDEO_H264_MAX_NUM_LIST_REF]") ByteBuffer value) {
            StdVideoEncodeH264ReferenceListsInfo.nRefPicList1(this.address(), value);
            return this;
        }

        public Buffer RefPicList1(int index, @NativeType(value="uint8_t") byte value) {
            StdVideoEncodeH264ReferenceListsInfo.nRefPicList1(this.address(), index, value);
            return this;
        }

        public Buffer refList0ModOpCount(@NativeType(value="uint8_t") byte value) {
            StdVideoEncodeH264ReferenceListsInfo.nrefList0ModOpCount(this.address(), value);
            return this;
        }

        public Buffer refList1ModOpCount(@NativeType(value="uint8_t") byte value) {
            StdVideoEncodeH264ReferenceListsInfo.nrefList1ModOpCount(this.address(), value);
            return this;
        }

        public Buffer pRefList0ModOperations(@NativeType(value="StdVideoEncodeH264RefListModEntry const *") @Nullable StdVideoEncodeH264RefListModEntry.Buffer value) {
            StdVideoEncodeH264ReferenceListsInfo.npRefList0ModOperations(this.address(), value);
            return this;
        }

        public Buffer pRefList1ModOperations(@NativeType(value="StdVideoEncodeH264RefListModEntry const *") @Nullable StdVideoEncodeH264RefListModEntry.Buffer value) {
            StdVideoEncodeH264ReferenceListsInfo.npRefList1ModOperations(this.address(), value);
            return this;
        }

        public Buffer pRefPicMarkingOperations(@NativeType(value="StdVideoEncodeH264RefPicMarkingEntry const *") StdVideoEncodeH264RefPicMarkingEntry.Buffer value) {
            StdVideoEncodeH264ReferenceListsInfo.npRefPicMarkingOperations(this.address(), value);
            return this;
        }
    }
}

