/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan.video;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.video.StdVideoEncodeH265LongTermRefPics;
import org.lwjgl.vulkan.video.StdVideoEncodeH265PictureInfoFlags;
import org.lwjgl.vulkan.video.StdVideoEncodeH265ReferenceModifications;
import org.lwjgl.vulkan.video.StdVideoH265ShortTermRefPicSet;

public class StdVideoEncodeH265PictureInfo
extends Struct<StdVideoEncodeH265PictureInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int PIC_TYPE;
    public static final int SPS_VIDEO_PARAMETER_SET_ID;
    public static final int PPS_SEQ_PARAMETER_SET_ID;
    public static final int PPS_PIC_PARAMETER_SET_ID;
    public static final int SHORT_TERM_REF_PIC_SET_IDX;
    public static final int PICORDERCNTVAL;
    public static final int TEMPORALID;
    public static final int RESERVED1;
    public static final int PREFLISTS;
    public static final int PSHORTTERMREFPICSET;
    public static final int PLONGTERMREFPICS;

    protected StdVideoEncodeH265PictureInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected StdVideoEncodeH265PictureInfo create(long address, @Nullable ByteBuffer container) {
        return new StdVideoEncodeH265PictureInfo(address, container);
    }

    public StdVideoEncodeH265PictureInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), StdVideoEncodeH265PictureInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public StdVideoEncodeH265PictureInfoFlags flags() {
        return StdVideoEncodeH265PictureInfo.nflags(this.address());
    }

    @NativeType(value="StdVideoH265PictureType")
    public int pic_type() {
        return StdVideoEncodeH265PictureInfo.npic_type(this.address());
    }

    @NativeType(value="uint8_t")
    public byte sps_video_parameter_set_id() {
        return StdVideoEncodeH265PictureInfo.nsps_video_parameter_set_id(this.address());
    }

    @NativeType(value="uint8_t")
    public byte pps_seq_parameter_set_id() {
        return StdVideoEncodeH265PictureInfo.npps_seq_parameter_set_id(this.address());
    }

    @NativeType(value="uint8_t")
    public byte pps_pic_parameter_set_id() {
        return StdVideoEncodeH265PictureInfo.npps_pic_parameter_set_id(this.address());
    }

    @NativeType(value="uint8_t")
    public byte short_term_ref_pic_set_idx() {
        return StdVideoEncodeH265PictureInfo.nshort_term_ref_pic_set_idx(this.address());
    }

    @NativeType(value="int32_t")
    public int PicOrderCntVal() {
        return StdVideoEncodeH265PictureInfo.nPicOrderCntVal(this.address());
    }

    @NativeType(value="uint8_t")
    public byte TemporalId() {
        return StdVideoEncodeH265PictureInfo.nTemporalId(this.address());
    }

    @NativeType(value="StdVideoEncodeH265ReferenceModifications const *")
    public StdVideoEncodeH265ReferenceModifications pRefLists() {
        return StdVideoEncodeH265PictureInfo.npRefLists(this.address());
    }

    @NativeType(value="StdVideoH265ShortTermRefPicSet const *")
    public StdVideoH265ShortTermRefPicSet pShortTermRefPicSet() {
        return StdVideoEncodeH265PictureInfo.npShortTermRefPicSet(this.address());
    }

    @NativeType(value="StdVideoEncodeH265LongTermRefPics const *")
    public StdVideoEncodeH265LongTermRefPics pLongTermRefPics() {
        return StdVideoEncodeH265PictureInfo.npLongTermRefPics(this.address());
    }

    public StdVideoEncodeH265PictureInfo flags(StdVideoEncodeH265PictureInfoFlags value) {
        StdVideoEncodeH265PictureInfo.nflags(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265PictureInfo flags(Consumer<StdVideoEncodeH265PictureInfoFlags> consumer) {
        consumer.accept(this.flags());
        return this;
    }

    public StdVideoEncodeH265PictureInfo pic_type(@NativeType(value="StdVideoH265PictureType") int value) {
        StdVideoEncodeH265PictureInfo.npic_type(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265PictureInfo sps_video_parameter_set_id(@NativeType(value="uint8_t") byte value) {
        StdVideoEncodeH265PictureInfo.nsps_video_parameter_set_id(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265PictureInfo pps_seq_parameter_set_id(@NativeType(value="uint8_t") byte value) {
        StdVideoEncodeH265PictureInfo.npps_seq_parameter_set_id(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265PictureInfo pps_pic_parameter_set_id(@NativeType(value="uint8_t") byte value) {
        StdVideoEncodeH265PictureInfo.npps_pic_parameter_set_id(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265PictureInfo short_term_ref_pic_set_idx(@NativeType(value="uint8_t") byte value) {
        StdVideoEncodeH265PictureInfo.nshort_term_ref_pic_set_idx(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265PictureInfo PicOrderCntVal(@NativeType(value="int32_t") int value) {
        StdVideoEncodeH265PictureInfo.nPicOrderCntVal(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265PictureInfo TemporalId(@NativeType(value="uint8_t") byte value) {
        StdVideoEncodeH265PictureInfo.nTemporalId(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265PictureInfo pRefLists(@NativeType(value="StdVideoEncodeH265ReferenceModifications const *") StdVideoEncodeH265ReferenceModifications value) {
        StdVideoEncodeH265PictureInfo.npRefLists(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265PictureInfo pShortTermRefPicSet(@NativeType(value="StdVideoH265ShortTermRefPicSet const *") StdVideoH265ShortTermRefPicSet value) {
        StdVideoEncodeH265PictureInfo.npShortTermRefPicSet(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265PictureInfo pLongTermRefPics(@NativeType(value="StdVideoEncodeH265LongTermRefPics const *") StdVideoEncodeH265LongTermRefPics value) {
        StdVideoEncodeH265PictureInfo.npLongTermRefPics(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265PictureInfo set(StdVideoEncodeH265PictureInfoFlags flags, int pic_type, byte sps_video_parameter_set_id, byte pps_seq_parameter_set_id, byte pps_pic_parameter_set_id, byte short_term_ref_pic_set_idx, int PicOrderCntVal, byte TemporalId, StdVideoEncodeH265ReferenceModifications pRefLists, StdVideoH265ShortTermRefPicSet pShortTermRefPicSet, StdVideoEncodeH265LongTermRefPics pLongTermRefPics) {
        this.flags(flags);
        this.pic_type(pic_type);
        this.sps_video_parameter_set_id(sps_video_parameter_set_id);
        this.pps_seq_parameter_set_id(pps_seq_parameter_set_id);
        this.pps_pic_parameter_set_id(pps_pic_parameter_set_id);
        this.short_term_ref_pic_set_idx(short_term_ref_pic_set_idx);
        this.PicOrderCntVal(PicOrderCntVal);
        this.TemporalId(TemporalId);
        this.pRefLists(pRefLists);
        this.pShortTermRefPicSet(pShortTermRefPicSet);
        this.pLongTermRefPics(pLongTermRefPics);
        return this;
    }

    public StdVideoEncodeH265PictureInfo set(StdVideoEncodeH265PictureInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static StdVideoEncodeH265PictureInfo malloc() {
        return new StdVideoEncodeH265PictureInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static StdVideoEncodeH265PictureInfo calloc() {
        return new StdVideoEncodeH265PictureInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static StdVideoEncodeH265PictureInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new StdVideoEncodeH265PictureInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static StdVideoEncodeH265PictureInfo create(long address) {
        return new StdVideoEncodeH265PictureInfo(address, null);
    }

    public static @Nullable StdVideoEncodeH265PictureInfo createSafe(long address) {
        return address == 0L ? null : new StdVideoEncodeH265PictureInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)StdVideoEncodeH265PictureInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = StdVideoEncodeH265PictureInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static StdVideoEncodeH265PictureInfo malloc(MemoryStack stack) {
        return new StdVideoEncodeH265PictureInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static StdVideoEncodeH265PictureInfo calloc(MemoryStack stack) {
        return new StdVideoEncodeH265PictureInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static StdVideoEncodeH265PictureInfoFlags nflags(long struct) {
        return StdVideoEncodeH265PictureInfoFlags.create(struct + (long)FLAGS);
    }

    public static int npic_type(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)PIC_TYPE));
    }

    public static byte nsps_video_parameter_set_id(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)SPS_VIDEO_PARAMETER_SET_ID));
    }

    public static byte npps_seq_parameter_set_id(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)PPS_SEQ_PARAMETER_SET_ID));
    }

    public static byte npps_pic_parameter_set_id(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)PPS_PIC_PARAMETER_SET_ID));
    }

    public static byte nshort_term_ref_pic_set_idx(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)SHORT_TERM_REF_PIC_SET_IDX));
    }

    public static int nPicOrderCntVal(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)PICORDERCNTVAL));
    }

    public static byte nTemporalId(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)TEMPORALID));
    }

    public static ByteBuffer nreserved1(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)RESERVED1), (int)7);
    }

    public static byte nreserved1(long struct, int index) {
        return MemoryUtil.memGetByte((long)(struct + (long)RESERVED1 + Checks.check((int)index, (int)7) * 1L));
    }

    public static StdVideoEncodeH265ReferenceModifications npRefLists(long struct) {
        return StdVideoEncodeH265ReferenceModifications.create(MemoryUtil.memGetAddress((long)(struct + (long)PREFLISTS)));
    }

    public static StdVideoH265ShortTermRefPicSet npShortTermRefPicSet(long struct) {
        return StdVideoH265ShortTermRefPicSet.create(MemoryUtil.memGetAddress((long)(struct + (long)PSHORTTERMREFPICSET)));
    }

    public static StdVideoEncodeH265LongTermRefPics npLongTermRefPics(long struct) {
        return StdVideoEncodeH265LongTermRefPics.create(MemoryUtil.memGetAddress((long)(struct + (long)PLONGTERMREFPICS)));
    }

    public static void nflags(long struct, StdVideoEncodeH265PictureInfoFlags value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)FLAGS), (long)StdVideoEncodeH265PictureInfoFlags.SIZEOF);
    }

    public static void npic_type(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)PIC_TYPE), (int)value);
    }

    public static void nsps_video_parameter_set_id(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)SPS_VIDEO_PARAMETER_SET_ID), (byte)value);
    }

    public static void npps_seq_parameter_set_id(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)PPS_SEQ_PARAMETER_SET_ID), (byte)value);
    }

    public static void npps_pic_parameter_set_id(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)PPS_PIC_PARAMETER_SET_ID), (byte)value);
    }

    public static void nshort_term_ref_pic_set_idx(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)SHORT_TERM_REF_PIC_SET_IDX), (byte)value);
    }

    public static void nPicOrderCntVal(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)PICORDERCNTVAL), (int)value);
    }

    public static void nTemporalId(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)TEMPORALID), (byte)value);
    }

    public static void nreserved1(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)7);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)RESERVED1), (long)(value.remaining() * 1));
    }

    public static void nreserved1(long struct, int index, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)RESERVED1 + Checks.check((int)index, (int)7) * 1L), (byte)value);
    }

    public static void npRefLists(long struct, StdVideoEncodeH265ReferenceModifications value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PREFLISTS), (long)value.address());
    }

    public static void npShortTermRefPicSet(long struct, StdVideoH265ShortTermRefPicSet value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PSHORTTERMREFPICSET), (long)value.address());
    }

    public static void npLongTermRefPics(long struct, StdVideoEncodeH265LongTermRefPics value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PLONGTERMREFPICS), (long)value.address());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PREFLISTS)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PSHORTTERMREFPICSET)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PLONGTERMREFPICS)));
    }

    static {
        Struct.Layout layout = StdVideoEncodeH265PictureInfo.__struct((Struct.Member[])new Struct.Member[]{StdVideoEncodeH265PictureInfo.__member((int)StdVideoEncodeH265PictureInfoFlags.SIZEOF, (int)StdVideoEncodeH265PictureInfoFlags.ALIGNOF), StdVideoEncodeH265PictureInfo.__member((int)4), StdVideoEncodeH265PictureInfo.__member((int)1), StdVideoEncodeH265PictureInfo.__member((int)1), StdVideoEncodeH265PictureInfo.__member((int)1), StdVideoEncodeH265PictureInfo.__member((int)1), StdVideoEncodeH265PictureInfo.__member((int)4), StdVideoEncodeH265PictureInfo.__member((int)1), StdVideoEncodeH265PictureInfo.__array((int)1, (int)7), StdVideoEncodeH265PictureInfo.__member((int)POINTER_SIZE), StdVideoEncodeH265PictureInfo.__member((int)POINTER_SIZE), StdVideoEncodeH265PictureInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        PIC_TYPE = layout.offsetof(1);
        SPS_VIDEO_PARAMETER_SET_ID = layout.offsetof(2);
        PPS_SEQ_PARAMETER_SET_ID = layout.offsetof(3);
        PPS_PIC_PARAMETER_SET_ID = layout.offsetof(4);
        SHORT_TERM_REF_PIC_SET_IDX = layout.offsetof(5);
        PICORDERCNTVAL = layout.offsetof(6);
        TEMPORALID = layout.offsetof(7);
        RESERVED1 = layout.offsetof(8);
        PREFLISTS = layout.offsetof(9);
        PSHORTTERMREFPICSET = layout.offsetof(10);
        PLONGTERMREFPICS = layout.offsetof(11);
    }

    public static class Buffer
    extends StructBuffer<StdVideoEncodeH265PictureInfo, Buffer>
    implements NativeResource {
        private static final StdVideoEncodeH265PictureInfo ELEMENT_FACTORY = StdVideoEncodeH265PictureInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected StdVideoEncodeH265PictureInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public StdVideoEncodeH265PictureInfoFlags flags() {
            return StdVideoEncodeH265PictureInfo.nflags(this.address());
        }

        @NativeType(value="StdVideoH265PictureType")
        public int pic_type() {
            return StdVideoEncodeH265PictureInfo.npic_type(this.address());
        }

        @NativeType(value="uint8_t")
        public byte sps_video_parameter_set_id() {
            return StdVideoEncodeH265PictureInfo.nsps_video_parameter_set_id(this.address());
        }

        @NativeType(value="uint8_t")
        public byte pps_seq_parameter_set_id() {
            return StdVideoEncodeH265PictureInfo.npps_seq_parameter_set_id(this.address());
        }

        @NativeType(value="uint8_t")
        public byte pps_pic_parameter_set_id() {
            return StdVideoEncodeH265PictureInfo.npps_pic_parameter_set_id(this.address());
        }

        @NativeType(value="uint8_t")
        public byte short_term_ref_pic_set_idx() {
            return StdVideoEncodeH265PictureInfo.nshort_term_ref_pic_set_idx(this.address());
        }

        @NativeType(value="int32_t")
        public int PicOrderCntVal() {
            return StdVideoEncodeH265PictureInfo.nPicOrderCntVal(this.address());
        }

        @NativeType(value="uint8_t")
        public byte TemporalId() {
            return StdVideoEncodeH265PictureInfo.nTemporalId(this.address());
        }

        @NativeType(value="StdVideoEncodeH265ReferenceModifications const *")
        public StdVideoEncodeH265ReferenceModifications pRefLists() {
            return StdVideoEncodeH265PictureInfo.npRefLists(this.address());
        }

        @NativeType(value="StdVideoH265ShortTermRefPicSet const *")
        public StdVideoH265ShortTermRefPicSet pShortTermRefPicSet() {
            return StdVideoEncodeH265PictureInfo.npShortTermRefPicSet(this.address());
        }

        @NativeType(value="StdVideoEncodeH265LongTermRefPics const *")
        public StdVideoEncodeH265LongTermRefPics pLongTermRefPics() {
            return StdVideoEncodeH265PictureInfo.npLongTermRefPics(this.address());
        }

        public Buffer flags(StdVideoEncodeH265PictureInfoFlags value) {
            StdVideoEncodeH265PictureInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer flags(Consumer<StdVideoEncodeH265PictureInfoFlags> consumer) {
            consumer.accept(this.flags());
            return this;
        }

        public Buffer pic_type(@NativeType(value="StdVideoH265PictureType") int value) {
            StdVideoEncodeH265PictureInfo.npic_type(this.address(), value);
            return this;
        }

        public Buffer sps_video_parameter_set_id(@NativeType(value="uint8_t") byte value) {
            StdVideoEncodeH265PictureInfo.nsps_video_parameter_set_id(this.address(), value);
            return this;
        }

        public Buffer pps_seq_parameter_set_id(@NativeType(value="uint8_t") byte value) {
            StdVideoEncodeH265PictureInfo.npps_seq_parameter_set_id(this.address(), value);
            return this;
        }

        public Buffer pps_pic_parameter_set_id(@NativeType(value="uint8_t") byte value) {
            StdVideoEncodeH265PictureInfo.npps_pic_parameter_set_id(this.address(), value);
            return this;
        }

        public Buffer short_term_ref_pic_set_idx(@NativeType(value="uint8_t") byte value) {
            StdVideoEncodeH265PictureInfo.nshort_term_ref_pic_set_idx(this.address(), value);
            return this;
        }

        public Buffer PicOrderCntVal(@NativeType(value="int32_t") int value) {
            StdVideoEncodeH265PictureInfo.nPicOrderCntVal(this.address(), value);
            return this;
        }

        public Buffer TemporalId(@NativeType(value="uint8_t") byte value) {
            StdVideoEncodeH265PictureInfo.nTemporalId(this.address(), value);
            return this;
        }

        public Buffer pRefLists(@NativeType(value="StdVideoEncodeH265ReferenceModifications const *") StdVideoEncodeH265ReferenceModifications value) {
            StdVideoEncodeH265PictureInfo.npRefLists(this.address(), value);
            return this;
        }

        public Buffer pShortTermRefPicSet(@NativeType(value="StdVideoH265ShortTermRefPicSet const *") StdVideoH265ShortTermRefPicSet value) {
            StdVideoEncodeH265PictureInfo.npShortTermRefPicSet(this.address(), value);
            return this;
        }

        public Buffer pLongTermRefPics(@NativeType(value="StdVideoEncodeH265LongTermRefPics const *") StdVideoEncodeH265LongTermRefPics value) {
            StdVideoEncodeH265PictureInfo.npLongTermRefPics(this.address(), value);
            return this;
        }
    }
}

