/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan.video;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class StdVideoH264ScalingLists
extends Struct<StdVideoH264ScalingLists>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SCALING_LIST_PRESENT_MASK;
    public static final int USE_DEFAULT_SCALING_MATRIX_MASK;
    public static final int SCALINGLIST4X4;
    public static final int SCALINGLIST8X8;

    protected StdVideoH264ScalingLists(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected StdVideoH264ScalingLists create(long address, @Nullable ByteBuffer container) {
        return new StdVideoH264ScalingLists(address, container);
    }

    public StdVideoH264ScalingLists(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), StdVideoH264ScalingLists.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint16_t")
    public short scaling_list_present_mask() {
        return StdVideoH264ScalingLists.nscaling_list_present_mask(this.address());
    }

    @NativeType(value="uint16_t")
    public short use_default_scaling_matrix_mask() {
        return StdVideoH264ScalingLists.nuse_default_scaling_matrix_mask(this.address());
    }

    @NativeType(value="uint8_t[STD_VIDEO_H264_SCALING_LIST_4X4_NUM_ELEMENTS]")
    public ByteBuffer ScalingList4x4() {
        return StdVideoH264ScalingLists.nScalingList4x4(this.address());
    }

    @NativeType(value="uint8_t")
    public byte ScalingList4x4(int index) {
        return StdVideoH264ScalingLists.nScalingList4x4(this.address(), index);
    }

    @NativeType(value="uint8_t[STD_VIDEO_H264_SCALING_LIST_8X8_NUM_ELEMENTS]")
    public ByteBuffer ScalingList8x8() {
        return StdVideoH264ScalingLists.nScalingList8x8(this.address());
    }

    @NativeType(value="uint8_t")
    public byte ScalingList8x8(int index) {
        return StdVideoH264ScalingLists.nScalingList8x8(this.address(), index);
    }

    public StdVideoH264ScalingLists scaling_list_present_mask(@NativeType(value="uint16_t") short value) {
        StdVideoH264ScalingLists.nscaling_list_present_mask(this.address(), value);
        return this;
    }

    public StdVideoH264ScalingLists use_default_scaling_matrix_mask(@NativeType(value="uint16_t") short value) {
        StdVideoH264ScalingLists.nuse_default_scaling_matrix_mask(this.address(), value);
        return this;
    }

    public StdVideoH264ScalingLists ScalingList4x4(@NativeType(value="uint8_t[STD_VIDEO_H264_SCALING_LIST_4X4_NUM_ELEMENTS]") ByteBuffer value) {
        StdVideoH264ScalingLists.nScalingList4x4(this.address(), value);
        return this;
    }

    public StdVideoH264ScalingLists ScalingList4x4(int index, @NativeType(value="uint8_t") byte value) {
        StdVideoH264ScalingLists.nScalingList4x4(this.address(), index, value);
        return this;
    }

    public StdVideoH264ScalingLists ScalingList8x8(@NativeType(value="uint8_t[STD_VIDEO_H264_SCALING_LIST_8X8_NUM_ELEMENTS]") ByteBuffer value) {
        StdVideoH264ScalingLists.nScalingList8x8(this.address(), value);
        return this;
    }

    public StdVideoH264ScalingLists ScalingList8x8(int index, @NativeType(value="uint8_t") byte value) {
        StdVideoH264ScalingLists.nScalingList8x8(this.address(), index, value);
        return this;
    }

    public StdVideoH264ScalingLists set(short scaling_list_present_mask, short use_default_scaling_matrix_mask, ByteBuffer ScalingList4x4, ByteBuffer ScalingList8x8) {
        this.scaling_list_present_mask(scaling_list_present_mask);
        this.use_default_scaling_matrix_mask(use_default_scaling_matrix_mask);
        this.ScalingList4x4(ScalingList4x4);
        this.ScalingList8x8(ScalingList8x8);
        return this;
    }

    public StdVideoH264ScalingLists set(StdVideoH264ScalingLists src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static StdVideoH264ScalingLists malloc() {
        return new StdVideoH264ScalingLists(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static StdVideoH264ScalingLists calloc() {
        return new StdVideoH264ScalingLists(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static StdVideoH264ScalingLists create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new StdVideoH264ScalingLists(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static StdVideoH264ScalingLists create(long address) {
        return new StdVideoH264ScalingLists(address, null);
    }

    public static @Nullable StdVideoH264ScalingLists createSafe(long address) {
        return address == 0L ? null : new StdVideoH264ScalingLists(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)StdVideoH264ScalingLists.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = StdVideoH264ScalingLists.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static StdVideoH264ScalingLists malloc(MemoryStack stack) {
        return new StdVideoH264ScalingLists(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static StdVideoH264ScalingLists calloc(MemoryStack stack) {
        return new StdVideoH264ScalingLists(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static short nscaling_list_present_mask(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)SCALING_LIST_PRESENT_MASK));
    }

    public static short nuse_default_scaling_matrix_mask(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)USE_DEFAULT_SCALING_MATRIX_MASK));
    }

    public static ByteBuffer nScalingList4x4(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)SCALINGLIST4X4), (int)16);
    }

    public static byte nScalingList4x4(long struct, int index) {
        return MemoryUtil.memGetByte((long)(struct + (long)SCALINGLIST4X4 + Checks.check((int)index, (int)16) * 1L));
    }

    public static ByteBuffer nScalingList8x8(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)SCALINGLIST8X8), (int)64);
    }

    public static byte nScalingList8x8(long struct, int index) {
        return MemoryUtil.memGetByte((long)(struct + (long)SCALINGLIST8X8 + Checks.check((int)index, (int)64) * 1L));
    }

    public static void nscaling_list_present_mask(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)SCALING_LIST_PRESENT_MASK), (short)value);
    }

    public static void nuse_default_scaling_matrix_mask(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)USE_DEFAULT_SCALING_MATRIX_MASK), (short)value);
    }

    public static void nScalingList4x4(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)16);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)SCALINGLIST4X4), (long)(value.remaining() * 1));
    }

    public static void nScalingList4x4(long struct, int index, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)SCALINGLIST4X4 + Checks.check((int)index, (int)16) * 1L), (byte)value);
    }

    public static void nScalingList8x8(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)64);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)SCALINGLIST8X8), (long)(value.remaining() * 1));
    }

    public static void nScalingList8x8(long struct, int index, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)SCALINGLIST8X8 + Checks.check((int)index, (int)64) * 1L), (byte)value);
    }

    static {
        Struct.Layout layout = StdVideoH264ScalingLists.__struct((Struct.Member[])new Struct.Member[]{StdVideoH264ScalingLists.__member((int)2), StdVideoH264ScalingLists.__member((int)2), StdVideoH264ScalingLists.__array((int)1, (int)16), StdVideoH264ScalingLists.__array((int)1, (int)64)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SCALING_LIST_PRESENT_MASK = layout.offsetof(0);
        USE_DEFAULT_SCALING_MATRIX_MASK = layout.offsetof(1);
        SCALINGLIST4X4 = layout.offsetof(2);
        SCALINGLIST8X8 = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<StdVideoH264ScalingLists, Buffer>
    implements NativeResource {
        private static final StdVideoH264ScalingLists ELEMENT_FACTORY = StdVideoH264ScalingLists.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected StdVideoH264ScalingLists getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint16_t")
        public short scaling_list_present_mask() {
            return StdVideoH264ScalingLists.nscaling_list_present_mask(this.address());
        }

        @NativeType(value="uint16_t")
        public short use_default_scaling_matrix_mask() {
            return StdVideoH264ScalingLists.nuse_default_scaling_matrix_mask(this.address());
        }

        @NativeType(value="uint8_t[STD_VIDEO_H264_SCALING_LIST_4X4_NUM_ELEMENTS]")
        public ByteBuffer ScalingList4x4() {
            return StdVideoH264ScalingLists.nScalingList4x4(this.address());
        }

        @NativeType(value="uint8_t")
        public byte ScalingList4x4(int index) {
            return StdVideoH264ScalingLists.nScalingList4x4(this.address(), index);
        }

        @NativeType(value="uint8_t[STD_VIDEO_H264_SCALING_LIST_8X8_NUM_ELEMENTS]")
        public ByteBuffer ScalingList8x8() {
            return StdVideoH264ScalingLists.nScalingList8x8(this.address());
        }

        @NativeType(value="uint8_t")
        public byte ScalingList8x8(int index) {
            return StdVideoH264ScalingLists.nScalingList8x8(this.address(), index);
        }

        public Buffer scaling_list_present_mask(@NativeType(value="uint16_t") short value) {
            StdVideoH264ScalingLists.nscaling_list_present_mask(this.address(), value);
            return this;
        }

        public Buffer use_default_scaling_matrix_mask(@NativeType(value="uint16_t") short value) {
            StdVideoH264ScalingLists.nuse_default_scaling_matrix_mask(this.address(), value);
            return this;
        }

        public Buffer ScalingList4x4(@NativeType(value="uint8_t[STD_VIDEO_H264_SCALING_LIST_4X4_NUM_ELEMENTS]") ByteBuffer value) {
            StdVideoH264ScalingLists.nScalingList4x4(this.address(), value);
            return this;
        }

        public Buffer ScalingList4x4(int index, @NativeType(value="uint8_t") byte value) {
            StdVideoH264ScalingLists.nScalingList4x4(this.address(), index, value);
            return this;
        }

        public Buffer ScalingList8x8(@NativeType(value="uint8_t[STD_VIDEO_H264_SCALING_LIST_8X8_NUM_ELEMENTS]") ByteBuffer value) {
            StdVideoH264ScalingLists.nScalingList8x8(this.address(), value);
            return this;
        }

        public Buffer ScalingList8x8(int index, @NativeType(value="uint8_t") byte value) {
            StdVideoH264ScalingLists.nScalingList8x8(this.address(), index, value);
            return this;
        }
    }
}

