/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan.video;

import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.video.StdVideoH265HrdFlags;
import org.lwjgl.vulkan.video.StdVideoH265SubLayerHrdParameters;

public class StdVideoH265HrdParameters
extends Struct<StdVideoH265HrdParameters>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int TICK_DIVISOR_MINUS2;
    public static final int DU_CPB_REMOVAL_DELAY_INCREMENT_LENGTH_MINUS1;
    public static final int DPB_OUTPUT_DELAY_DU_LENGTH_MINUS1;
    public static final int BIT_RATE_SCALE;
    public static final int CPB_SIZE_SCALE;
    public static final int CPB_SIZE_DU_SCALE;
    public static final int INITIAL_CPB_REMOVAL_DELAY_LENGTH_MINUS1;
    public static final int AU_CPB_REMOVAL_DELAY_LENGTH_MINUS1;
    public static final int DPB_OUTPUT_DELAY_LENGTH_MINUS1;
    public static final int CPB_CNT_MINUS1;
    public static final int ELEMENTAL_DURATION_IN_TC_MINUS1;
    public static final int RESERVED;
    public static final int PSUBLAYERHRDPARAMETERSNAL;
    public static final int PSUBLAYERHRDPARAMETERSVCL;

    protected StdVideoH265HrdParameters(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected StdVideoH265HrdParameters create(long address, @Nullable ByteBuffer container) {
        return new StdVideoH265HrdParameters(address, container);
    }

    public StdVideoH265HrdParameters(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), StdVideoH265HrdParameters.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public StdVideoH265HrdFlags flags() {
        return StdVideoH265HrdParameters.nflags(this.address());
    }

    @NativeType(value="uint8_t")
    public byte tick_divisor_minus2() {
        return StdVideoH265HrdParameters.ntick_divisor_minus2(this.address());
    }

    @NativeType(value="uint8_t")
    public byte du_cpb_removal_delay_increment_length_minus1() {
        return StdVideoH265HrdParameters.ndu_cpb_removal_delay_increment_length_minus1(this.address());
    }

    @NativeType(value="uint8_t")
    public byte dpb_output_delay_du_length_minus1() {
        return StdVideoH265HrdParameters.ndpb_output_delay_du_length_minus1(this.address());
    }

    @NativeType(value="uint8_t")
    public byte bit_rate_scale() {
        return StdVideoH265HrdParameters.nbit_rate_scale(this.address());
    }

    @NativeType(value="uint8_t")
    public byte cpb_size_scale() {
        return StdVideoH265HrdParameters.ncpb_size_scale(this.address());
    }

    @NativeType(value="uint8_t")
    public byte cpb_size_du_scale() {
        return StdVideoH265HrdParameters.ncpb_size_du_scale(this.address());
    }

    @NativeType(value="uint8_t")
    public byte initial_cpb_removal_delay_length_minus1() {
        return StdVideoH265HrdParameters.ninitial_cpb_removal_delay_length_minus1(this.address());
    }

    @NativeType(value="uint8_t")
    public byte au_cpb_removal_delay_length_minus1() {
        return StdVideoH265HrdParameters.nau_cpb_removal_delay_length_minus1(this.address());
    }

    @NativeType(value="uint8_t")
    public byte dpb_output_delay_length_minus1() {
        return StdVideoH265HrdParameters.ndpb_output_delay_length_minus1(this.address());
    }

    @NativeType(value="uint8_t[STD_VIDEO_H265_SUBLAYERS_LIST_SIZE]")
    public ByteBuffer cpb_cnt_minus1() {
        return StdVideoH265HrdParameters.ncpb_cnt_minus1(this.address());
    }

    @NativeType(value="uint8_t")
    public byte cpb_cnt_minus1(int index) {
        return StdVideoH265HrdParameters.ncpb_cnt_minus1(this.address(), index);
    }

    @NativeType(value="uint16_t[STD_VIDEO_H265_SUBLAYERS_LIST_SIZE]")
    public ShortBuffer elemental_duration_in_tc_minus1() {
        return StdVideoH265HrdParameters.nelemental_duration_in_tc_minus1(this.address());
    }

    @NativeType(value="uint16_t")
    public short elemental_duration_in_tc_minus1(int index) {
        return StdVideoH265HrdParameters.nelemental_duration_in_tc_minus1(this.address(), index);
    }

    @NativeType(value="StdVideoH265SubLayerHrdParameters const *")
    public StdVideoH265SubLayerHrdParameters pSubLayerHrdParametersNal() {
        return StdVideoH265HrdParameters.npSubLayerHrdParametersNal(this.address());
    }

    @NativeType(value="StdVideoH265SubLayerHrdParameters const *")
    public StdVideoH265SubLayerHrdParameters pSubLayerHrdParametersVcl() {
        return StdVideoH265HrdParameters.npSubLayerHrdParametersVcl(this.address());
    }

    public StdVideoH265HrdParameters flags(StdVideoH265HrdFlags value) {
        StdVideoH265HrdParameters.nflags(this.address(), value);
        return this;
    }

    public StdVideoH265HrdParameters flags(Consumer<StdVideoH265HrdFlags> consumer) {
        consumer.accept(this.flags());
        return this;
    }

    public StdVideoH265HrdParameters tick_divisor_minus2(@NativeType(value="uint8_t") byte value) {
        StdVideoH265HrdParameters.ntick_divisor_minus2(this.address(), value);
        return this;
    }

    public StdVideoH265HrdParameters du_cpb_removal_delay_increment_length_minus1(@NativeType(value="uint8_t") byte value) {
        StdVideoH265HrdParameters.ndu_cpb_removal_delay_increment_length_minus1(this.address(), value);
        return this;
    }

    public StdVideoH265HrdParameters dpb_output_delay_du_length_minus1(@NativeType(value="uint8_t") byte value) {
        StdVideoH265HrdParameters.ndpb_output_delay_du_length_minus1(this.address(), value);
        return this;
    }

    public StdVideoH265HrdParameters bit_rate_scale(@NativeType(value="uint8_t") byte value) {
        StdVideoH265HrdParameters.nbit_rate_scale(this.address(), value);
        return this;
    }

    public StdVideoH265HrdParameters cpb_size_scale(@NativeType(value="uint8_t") byte value) {
        StdVideoH265HrdParameters.ncpb_size_scale(this.address(), value);
        return this;
    }

    public StdVideoH265HrdParameters cpb_size_du_scale(@NativeType(value="uint8_t") byte value) {
        StdVideoH265HrdParameters.ncpb_size_du_scale(this.address(), value);
        return this;
    }

    public StdVideoH265HrdParameters initial_cpb_removal_delay_length_minus1(@NativeType(value="uint8_t") byte value) {
        StdVideoH265HrdParameters.ninitial_cpb_removal_delay_length_minus1(this.address(), value);
        return this;
    }

    public StdVideoH265HrdParameters au_cpb_removal_delay_length_minus1(@NativeType(value="uint8_t") byte value) {
        StdVideoH265HrdParameters.nau_cpb_removal_delay_length_minus1(this.address(), value);
        return this;
    }

    public StdVideoH265HrdParameters dpb_output_delay_length_minus1(@NativeType(value="uint8_t") byte value) {
        StdVideoH265HrdParameters.ndpb_output_delay_length_minus1(this.address(), value);
        return this;
    }

    public StdVideoH265HrdParameters cpb_cnt_minus1(@NativeType(value="uint8_t[STD_VIDEO_H265_SUBLAYERS_LIST_SIZE]") ByteBuffer value) {
        StdVideoH265HrdParameters.ncpb_cnt_minus1(this.address(), value);
        return this;
    }

    public StdVideoH265HrdParameters cpb_cnt_minus1(int index, @NativeType(value="uint8_t") byte value) {
        StdVideoH265HrdParameters.ncpb_cnt_minus1(this.address(), index, value);
        return this;
    }

    public StdVideoH265HrdParameters elemental_duration_in_tc_minus1(@NativeType(value="uint16_t[STD_VIDEO_H265_SUBLAYERS_LIST_SIZE]") ShortBuffer value) {
        StdVideoH265HrdParameters.nelemental_duration_in_tc_minus1(this.address(), value);
        return this;
    }

    public StdVideoH265HrdParameters elemental_duration_in_tc_minus1(int index, @NativeType(value="uint16_t") short value) {
        StdVideoH265HrdParameters.nelemental_duration_in_tc_minus1(this.address(), index, value);
        return this;
    }

    public StdVideoH265HrdParameters pSubLayerHrdParametersNal(@NativeType(value="StdVideoH265SubLayerHrdParameters const *") StdVideoH265SubLayerHrdParameters value) {
        StdVideoH265HrdParameters.npSubLayerHrdParametersNal(this.address(), value);
        return this;
    }

    public StdVideoH265HrdParameters pSubLayerHrdParametersVcl(@NativeType(value="StdVideoH265SubLayerHrdParameters const *") StdVideoH265SubLayerHrdParameters value) {
        StdVideoH265HrdParameters.npSubLayerHrdParametersVcl(this.address(), value);
        return this;
    }

    public StdVideoH265HrdParameters set(StdVideoH265HrdFlags flags, byte tick_divisor_minus2, byte du_cpb_removal_delay_increment_length_minus1, byte dpb_output_delay_du_length_minus1, byte bit_rate_scale, byte cpb_size_scale, byte cpb_size_du_scale, byte initial_cpb_removal_delay_length_minus1, byte au_cpb_removal_delay_length_minus1, byte dpb_output_delay_length_minus1, ByteBuffer cpb_cnt_minus1, ShortBuffer elemental_duration_in_tc_minus1, StdVideoH265SubLayerHrdParameters pSubLayerHrdParametersNal, StdVideoH265SubLayerHrdParameters pSubLayerHrdParametersVcl) {
        this.flags(flags);
        this.tick_divisor_minus2(tick_divisor_minus2);
        this.du_cpb_removal_delay_increment_length_minus1(du_cpb_removal_delay_increment_length_minus1);
        this.dpb_output_delay_du_length_minus1(dpb_output_delay_du_length_minus1);
        this.bit_rate_scale(bit_rate_scale);
        this.cpb_size_scale(cpb_size_scale);
        this.cpb_size_du_scale(cpb_size_du_scale);
        this.initial_cpb_removal_delay_length_minus1(initial_cpb_removal_delay_length_minus1);
        this.au_cpb_removal_delay_length_minus1(au_cpb_removal_delay_length_minus1);
        this.dpb_output_delay_length_minus1(dpb_output_delay_length_minus1);
        this.cpb_cnt_minus1(cpb_cnt_minus1);
        this.elemental_duration_in_tc_minus1(elemental_duration_in_tc_minus1);
        this.pSubLayerHrdParametersNal(pSubLayerHrdParametersNal);
        this.pSubLayerHrdParametersVcl(pSubLayerHrdParametersVcl);
        return this;
    }

    public StdVideoH265HrdParameters set(StdVideoH265HrdParameters src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static StdVideoH265HrdParameters malloc() {
        return new StdVideoH265HrdParameters(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static StdVideoH265HrdParameters calloc() {
        return new StdVideoH265HrdParameters(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static StdVideoH265HrdParameters create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new StdVideoH265HrdParameters(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static StdVideoH265HrdParameters create(long address) {
        return new StdVideoH265HrdParameters(address, null);
    }

    public static @Nullable StdVideoH265HrdParameters createSafe(long address) {
        return address == 0L ? null : new StdVideoH265HrdParameters(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)StdVideoH265HrdParameters.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = StdVideoH265HrdParameters.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static StdVideoH265HrdParameters malloc(MemoryStack stack) {
        return new StdVideoH265HrdParameters(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static StdVideoH265HrdParameters calloc(MemoryStack stack) {
        return new StdVideoH265HrdParameters(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static StdVideoH265HrdFlags nflags(long struct) {
        return StdVideoH265HrdFlags.create(struct + (long)FLAGS);
    }

    public static byte ntick_divisor_minus2(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)TICK_DIVISOR_MINUS2));
    }

    public static byte ndu_cpb_removal_delay_increment_length_minus1(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)DU_CPB_REMOVAL_DELAY_INCREMENT_LENGTH_MINUS1));
    }

    public static byte ndpb_output_delay_du_length_minus1(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)DPB_OUTPUT_DELAY_DU_LENGTH_MINUS1));
    }

    public static byte nbit_rate_scale(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)BIT_RATE_SCALE));
    }

    public static byte ncpb_size_scale(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)CPB_SIZE_SCALE));
    }

    public static byte ncpb_size_du_scale(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)CPB_SIZE_DU_SCALE));
    }

    public static byte ninitial_cpb_removal_delay_length_minus1(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)INITIAL_CPB_REMOVAL_DELAY_LENGTH_MINUS1));
    }

    public static byte nau_cpb_removal_delay_length_minus1(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)AU_CPB_REMOVAL_DELAY_LENGTH_MINUS1));
    }

    public static byte ndpb_output_delay_length_minus1(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)DPB_OUTPUT_DELAY_LENGTH_MINUS1));
    }

    public static ByteBuffer ncpb_cnt_minus1(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)CPB_CNT_MINUS1), (int)7);
    }

    public static byte ncpb_cnt_minus1(long struct, int index) {
        return MemoryUtil.memGetByte((long)(struct + (long)CPB_CNT_MINUS1 + Checks.check((int)index, (int)7) * 1L));
    }

    public static ShortBuffer nelemental_duration_in_tc_minus1(long struct) {
        return MemoryUtil.memShortBuffer((long)(struct + (long)ELEMENTAL_DURATION_IN_TC_MINUS1), (int)7);
    }

    public static short nelemental_duration_in_tc_minus1(long struct, int index) {
        return MemoryUtil.memGetShort((long)(struct + (long)ELEMENTAL_DURATION_IN_TC_MINUS1 + Checks.check((int)index, (int)7) * 2L));
    }

    public static ShortBuffer nreserved(long struct) {
        return MemoryUtil.memShortBuffer((long)(struct + (long)RESERVED), (int)3);
    }

    public static short nreserved(long struct, int index) {
        return MemoryUtil.memGetShort((long)(struct + (long)RESERVED + Checks.check((int)index, (int)3) * 2L));
    }

    public static StdVideoH265SubLayerHrdParameters npSubLayerHrdParametersNal(long struct) {
        return StdVideoH265SubLayerHrdParameters.create(MemoryUtil.memGetAddress((long)(struct + (long)PSUBLAYERHRDPARAMETERSNAL)));
    }

    public static StdVideoH265SubLayerHrdParameters npSubLayerHrdParametersVcl(long struct) {
        return StdVideoH265SubLayerHrdParameters.create(MemoryUtil.memGetAddress((long)(struct + (long)PSUBLAYERHRDPARAMETERSVCL)));
    }

    public static void nflags(long struct, StdVideoH265HrdFlags value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)FLAGS), (long)StdVideoH265HrdFlags.SIZEOF);
    }

    public static void ntick_divisor_minus2(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)TICK_DIVISOR_MINUS2), (byte)value);
    }

    public static void ndu_cpb_removal_delay_increment_length_minus1(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)DU_CPB_REMOVAL_DELAY_INCREMENT_LENGTH_MINUS1), (byte)value);
    }

    public static void ndpb_output_delay_du_length_minus1(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)DPB_OUTPUT_DELAY_DU_LENGTH_MINUS1), (byte)value);
    }

    public static void nbit_rate_scale(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)BIT_RATE_SCALE), (byte)value);
    }

    public static void ncpb_size_scale(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)CPB_SIZE_SCALE), (byte)value);
    }

    public static void ncpb_size_du_scale(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)CPB_SIZE_DU_SCALE), (byte)value);
    }

    public static void ninitial_cpb_removal_delay_length_minus1(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)INITIAL_CPB_REMOVAL_DELAY_LENGTH_MINUS1), (byte)value);
    }

    public static void nau_cpb_removal_delay_length_minus1(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)AU_CPB_REMOVAL_DELAY_LENGTH_MINUS1), (byte)value);
    }

    public static void ndpb_output_delay_length_minus1(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)DPB_OUTPUT_DELAY_LENGTH_MINUS1), (byte)value);
    }

    public static void ncpb_cnt_minus1(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)7);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)CPB_CNT_MINUS1), (long)(value.remaining() * 1));
    }

    public static void ncpb_cnt_minus1(long struct, int index, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)CPB_CNT_MINUS1 + Checks.check((int)index, (int)7) * 1L), (byte)value);
    }

    public static void nelemental_duration_in_tc_minus1(long struct, ShortBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)7);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ShortBuffer)value), (long)(struct + (long)ELEMENTAL_DURATION_IN_TC_MINUS1), (long)(value.remaining() * 2));
    }

    public static void nelemental_duration_in_tc_minus1(long struct, int index, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)ELEMENTAL_DURATION_IN_TC_MINUS1 + Checks.check((int)index, (int)7) * 2L), (short)value);
    }

    public static void nreserved(long struct, ShortBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)3);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ShortBuffer)value), (long)(struct + (long)RESERVED), (long)(value.remaining() * 2));
    }

    public static void nreserved(long struct, int index, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)RESERVED + Checks.check((int)index, (int)3) * 2L), (short)value);
    }

    public static void npSubLayerHrdParametersNal(long struct, StdVideoH265SubLayerHrdParameters value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PSUBLAYERHRDPARAMETERSNAL), (long)value.address());
    }

    public static void npSubLayerHrdParametersVcl(long struct, StdVideoH265SubLayerHrdParameters value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PSUBLAYERHRDPARAMETERSVCL), (long)value.address());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PSUBLAYERHRDPARAMETERSNAL)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PSUBLAYERHRDPARAMETERSVCL)));
    }

    static {
        Struct.Layout layout = StdVideoH265HrdParameters.__struct((Struct.Member[])new Struct.Member[]{StdVideoH265HrdParameters.__member((int)StdVideoH265HrdFlags.SIZEOF, (int)StdVideoH265HrdFlags.ALIGNOF), StdVideoH265HrdParameters.__member((int)1), StdVideoH265HrdParameters.__member((int)1), StdVideoH265HrdParameters.__member((int)1), StdVideoH265HrdParameters.__member((int)1), StdVideoH265HrdParameters.__member((int)1), StdVideoH265HrdParameters.__member((int)1), StdVideoH265HrdParameters.__member((int)1), StdVideoH265HrdParameters.__member((int)1), StdVideoH265HrdParameters.__member((int)1), StdVideoH265HrdParameters.__array((int)1, (int)7), StdVideoH265HrdParameters.__array((int)2, (int)7), StdVideoH265HrdParameters.__array((int)2, (int)3), StdVideoH265HrdParameters.__member((int)POINTER_SIZE), StdVideoH265HrdParameters.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        TICK_DIVISOR_MINUS2 = layout.offsetof(1);
        DU_CPB_REMOVAL_DELAY_INCREMENT_LENGTH_MINUS1 = layout.offsetof(2);
        DPB_OUTPUT_DELAY_DU_LENGTH_MINUS1 = layout.offsetof(3);
        BIT_RATE_SCALE = layout.offsetof(4);
        CPB_SIZE_SCALE = layout.offsetof(5);
        CPB_SIZE_DU_SCALE = layout.offsetof(6);
        INITIAL_CPB_REMOVAL_DELAY_LENGTH_MINUS1 = layout.offsetof(7);
        AU_CPB_REMOVAL_DELAY_LENGTH_MINUS1 = layout.offsetof(8);
        DPB_OUTPUT_DELAY_LENGTH_MINUS1 = layout.offsetof(9);
        CPB_CNT_MINUS1 = layout.offsetof(10);
        ELEMENTAL_DURATION_IN_TC_MINUS1 = layout.offsetof(11);
        RESERVED = layout.offsetof(12);
        PSUBLAYERHRDPARAMETERSNAL = layout.offsetof(13);
        PSUBLAYERHRDPARAMETERSVCL = layout.offsetof(14);
    }

    public static class Buffer
    extends StructBuffer<StdVideoH265HrdParameters, Buffer>
    implements NativeResource {
        private static final StdVideoH265HrdParameters ELEMENT_FACTORY = StdVideoH265HrdParameters.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected StdVideoH265HrdParameters getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public StdVideoH265HrdFlags flags() {
            return StdVideoH265HrdParameters.nflags(this.address());
        }

        @NativeType(value="uint8_t")
        public byte tick_divisor_minus2() {
            return StdVideoH265HrdParameters.ntick_divisor_minus2(this.address());
        }

        @NativeType(value="uint8_t")
        public byte du_cpb_removal_delay_increment_length_minus1() {
            return StdVideoH265HrdParameters.ndu_cpb_removal_delay_increment_length_minus1(this.address());
        }

        @NativeType(value="uint8_t")
        public byte dpb_output_delay_du_length_minus1() {
            return StdVideoH265HrdParameters.ndpb_output_delay_du_length_minus1(this.address());
        }

        @NativeType(value="uint8_t")
        public byte bit_rate_scale() {
            return StdVideoH265HrdParameters.nbit_rate_scale(this.address());
        }

        @NativeType(value="uint8_t")
        public byte cpb_size_scale() {
            return StdVideoH265HrdParameters.ncpb_size_scale(this.address());
        }

        @NativeType(value="uint8_t")
        public byte cpb_size_du_scale() {
            return StdVideoH265HrdParameters.ncpb_size_du_scale(this.address());
        }

        @NativeType(value="uint8_t")
        public byte initial_cpb_removal_delay_length_minus1() {
            return StdVideoH265HrdParameters.ninitial_cpb_removal_delay_length_minus1(this.address());
        }

        @NativeType(value="uint8_t")
        public byte au_cpb_removal_delay_length_minus1() {
            return StdVideoH265HrdParameters.nau_cpb_removal_delay_length_minus1(this.address());
        }

        @NativeType(value="uint8_t")
        public byte dpb_output_delay_length_minus1() {
            return StdVideoH265HrdParameters.ndpb_output_delay_length_minus1(this.address());
        }

        @NativeType(value="uint8_t[STD_VIDEO_H265_SUBLAYERS_LIST_SIZE]")
        public ByteBuffer cpb_cnt_minus1() {
            return StdVideoH265HrdParameters.ncpb_cnt_minus1(this.address());
        }

        @NativeType(value="uint8_t")
        public byte cpb_cnt_minus1(int index) {
            return StdVideoH265HrdParameters.ncpb_cnt_minus1(this.address(), index);
        }

        @NativeType(value="uint16_t[STD_VIDEO_H265_SUBLAYERS_LIST_SIZE]")
        public ShortBuffer elemental_duration_in_tc_minus1() {
            return StdVideoH265HrdParameters.nelemental_duration_in_tc_minus1(this.address());
        }

        @NativeType(value="uint16_t")
        public short elemental_duration_in_tc_minus1(int index) {
            return StdVideoH265HrdParameters.nelemental_duration_in_tc_minus1(this.address(), index);
        }

        @NativeType(value="StdVideoH265SubLayerHrdParameters const *")
        public StdVideoH265SubLayerHrdParameters pSubLayerHrdParametersNal() {
            return StdVideoH265HrdParameters.npSubLayerHrdParametersNal(this.address());
        }

        @NativeType(value="StdVideoH265SubLayerHrdParameters const *")
        public StdVideoH265SubLayerHrdParameters pSubLayerHrdParametersVcl() {
            return StdVideoH265HrdParameters.npSubLayerHrdParametersVcl(this.address());
        }

        public Buffer flags(StdVideoH265HrdFlags value) {
            StdVideoH265HrdParameters.nflags(this.address(), value);
            return this;
        }

        public Buffer flags(Consumer<StdVideoH265HrdFlags> consumer) {
            consumer.accept(this.flags());
            return this;
        }

        public Buffer tick_divisor_minus2(@NativeType(value="uint8_t") byte value) {
            StdVideoH265HrdParameters.ntick_divisor_minus2(this.address(), value);
            return this;
        }

        public Buffer du_cpb_removal_delay_increment_length_minus1(@NativeType(value="uint8_t") byte value) {
            StdVideoH265HrdParameters.ndu_cpb_removal_delay_increment_length_minus1(this.address(), value);
            return this;
        }

        public Buffer dpb_output_delay_du_length_minus1(@NativeType(value="uint8_t") byte value) {
            StdVideoH265HrdParameters.ndpb_output_delay_du_length_minus1(this.address(), value);
            return this;
        }

        public Buffer bit_rate_scale(@NativeType(value="uint8_t") byte value) {
            StdVideoH265HrdParameters.nbit_rate_scale(this.address(), value);
            return this;
        }

        public Buffer cpb_size_scale(@NativeType(value="uint8_t") byte value) {
            StdVideoH265HrdParameters.ncpb_size_scale(this.address(), value);
            return this;
        }

        public Buffer cpb_size_du_scale(@NativeType(value="uint8_t") byte value) {
            StdVideoH265HrdParameters.ncpb_size_du_scale(this.address(), value);
            return this;
        }

        public Buffer initial_cpb_removal_delay_length_minus1(@NativeType(value="uint8_t") byte value) {
            StdVideoH265HrdParameters.ninitial_cpb_removal_delay_length_minus1(this.address(), value);
            return this;
        }

        public Buffer au_cpb_removal_delay_length_minus1(@NativeType(value="uint8_t") byte value) {
            StdVideoH265HrdParameters.nau_cpb_removal_delay_length_minus1(this.address(), value);
            return this;
        }

        public Buffer dpb_output_delay_length_minus1(@NativeType(value="uint8_t") byte value) {
            StdVideoH265HrdParameters.ndpb_output_delay_length_minus1(this.address(), value);
            return this;
        }

        public Buffer cpb_cnt_minus1(@NativeType(value="uint8_t[STD_VIDEO_H265_SUBLAYERS_LIST_SIZE]") ByteBuffer value) {
            StdVideoH265HrdParameters.ncpb_cnt_minus1(this.address(), value);
            return this;
        }

        public Buffer cpb_cnt_minus1(int index, @NativeType(value="uint8_t") byte value) {
            StdVideoH265HrdParameters.ncpb_cnt_minus1(this.address(), index, value);
            return this;
        }

        public Buffer elemental_duration_in_tc_minus1(@NativeType(value="uint16_t[STD_VIDEO_H265_SUBLAYERS_LIST_SIZE]") ShortBuffer value) {
            StdVideoH265HrdParameters.nelemental_duration_in_tc_minus1(this.address(), value);
            return this;
        }

        public Buffer elemental_duration_in_tc_minus1(int index, @NativeType(value="uint16_t") short value) {
            StdVideoH265HrdParameters.nelemental_duration_in_tc_minus1(this.address(), index, value);
            return this;
        }

        public Buffer pSubLayerHrdParametersNal(@NativeType(value="StdVideoH265SubLayerHrdParameters const *") StdVideoH265SubLayerHrdParameters value) {
            StdVideoH265HrdParameters.npSubLayerHrdParametersNal(this.address(), value);
            return this;
        }

        public Buffer pSubLayerHrdParametersVcl(@NativeType(value="StdVideoH265SubLayerHrdParameters const *") StdVideoH265SubLayerHrdParameters value) {
            StdVideoH265HrdParameters.npSubLayerHrdParametersVcl(this.address(), value);
            return this;
        }
    }
}

