/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan.video;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.video.StdVideoH265DecPicBufMgr;
import org.lwjgl.vulkan.video.StdVideoH265LongTermRefPicsSps;
import org.lwjgl.vulkan.video.StdVideoH265PredictorPaletteEntries;
import org.lwjgl.vulkan.video.StdVideoH265ProfileTierLevel;
import org.lwjgl.vulkan.video.StdVideoH265ScalingLists;
import org.lwjgl.vulkan.video.StdVideoH265SequenceParameterSetVui;
import org.lwjgl.vulkan.video.StdVideoH265ShortTermRefPicSet;
import org.lwjgl.vulkan.video.StdVideoH265SpsFlags;

public class StdVideoH265SequenceParameterSet
extends Struct<StdVideoH265SequenceParameterSet>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int CHROMA_FORMAT_IDC;
    public static final int PIC_WIDTH_IN_LUMA_SAMPLES;
    public static final int PIC_HEIGHT_IN_LUMA_SAMPLES;
    public static final int SPS_VIDEO_PARAMETER_SET_ID;
    public static final int SPS_MAX_SUB_LAYERS_MINUS1;
    public static final int SPS_SEQ_PARAMETER_SET_ID;
    public static final int BIT_DEPTH_LUMA_MINUS8;
    public static final int BIT_DEPTH_CHROMA_MINUS8;
    public static final int LOG2_MAX_PIC_ORDER_CNT_LSB_MINUS4;
    public static final int SPS_MAX_DEC_PIC_BUFFERING_MINUS1;
    public static final int LOG2_MIN_LUMA_CODING_BLOCK_SIZE_MINUS3;
    public static final int LOG2_DIFF_MAX_MIN_LUMA_CODING_BLOCK_SIZE;
    public static final int LOG2_MIN_LUMA_TRANSFORM_BLOCK_SIZE_MINUS2;
    public static final int LOG2_DIFF_MAX_MIN_LUMA_TRANSFORM_BLOCK_SIZE;
    public static final int MAX_TRANSFORM_HIERARCHY_DEPTH_INTER;
    public static final int MAX_TRANSFORM_HIERARCHY_DEPTH_INTRA;
    public static final int NUM_SHORT_TERM_REF_PIC_SETS;
    public static final int NUM_LONG_TERM_REF_PICS_SPS;
    public static final int PCM_SAMPLE_BIT_DEPTH_LUMA_MINUS1;
    public static final int PCM_SAMPLE_BIT_DEPTH_CHROMA_MINUS1;
    public static final int LOG2_MIN_PCM_LUMA_CODING_BLOCK_SIZE_MINUS3;
    public static final int LOG2_DIFF_MAX_MIN_PCM_LUMA_CODING_BLOCK_SIZE;
    public static final int RESERVED1;
    public static final int RESERVED2;
    public static final int PALETTE_MAX_SIZE;
    public static final int DELTA_PALETTE_MAX_PREDICTOR_SIZE;
    public static final int MOTION_VECTOR_RESOLUTION_CONTROL_IDC;
    public static final int SPS_NUM_PALETTE_PREDICTOR_INITIALIZER_MINUS1;
    public static final int CONF_WIN_LEFT_OFFSET;
    public static final int CONF_WIN_RIGHT_OFFSET;
    public static final int CONF_WIN_TOP_OFFSET;
    public static final int CONF_WIN_BOTTOM_OFFSET;
    public static final int PPROFILETIERLEVEL;
    public static final int PDECPICBUFMGR;
    public static final int PSCALINGLISTS;
    public static final int PSHORTTERMREFPICSET;
    public static final int PLONGTERMREFPICSSPS;
    public static final int PSEQUENCEPARAMETERSETVUI;
    public static final int PPREDICTORPALETTEENTRIES;

    protected StdVideoH265SequenceParameterSet(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected StdVideoH265SequenceParameterSet create(long address, @Nullable ByteBuffer container) {
        return new StdVideoH265SequenceParameterSet(address, container);
    }

    public StdVideoH265SequenceParameterSet(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), StdVideoH265SequenceParameterSet.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public StdVideoH265SpsFlags flags() {
        return StdVideoH265SequenceParameterSet.nflags(this.address());
    }

    @NativeType(value="StdVideoH265ChromaFormatIdc")
    public int chroma_format_idc() {
        return StdVideoH265SequenceParameterSet.nchroma_format_idc(this.address());
    }

    @NativeType(value="uint32_t")
    public int pic_width_in_luma_samples() {
        return StdVideoH265SequenceParameterSet.npic_width_in_luma_samples(this.address());
    }

    @NativeType(value="uint32_t")
    public int pic_height_in_luma_samples() {
        return StdVideoH265SequenceParameterSet.npic_height_in_luma_samples(this.address());
    }

    @NativeType(value="uint8_t")
    public byte sps_video_parameter_set_id() {
        return StdVideoH265SequenceParameterSet.nsps_video_parameter_set_id(this.address());
    }

    @NativeType(value="uint8_t")
    public byte sps_max_sub_layers_minus1() {
        return StdVideoH265SequenceParameterSet.nsps_max_sub_layers_minus1(this.address());
    }

    @NativeType(value="uint8_t")
    public byte sps_seq_parameter_set_id() {
        return StdVideoH265SequenceParameterSet.nsps_seq_parameter_set_id(this.address());
    }

    @NativeType(value="uint8_t")
    public byte bit_depth_luma_minus8() {
        return StdVideoH265SequenceParameterSet.nbit_depth_luma_minus8(this.address());
    }

    @NativeType(value="uint8_t")
    public byte bit_depth_chroma_minus8() {
        return StdVideoH265SequenceParameterSet.nbit_depth_chroma_minus8(this.address());
    }

    @NativeType(value="uint8_t")
    public byte log2_max_pic_order_cnt_lsb_minus4() {
        return StdVideoH265SequenceParameterSet.nlog2_max_pic_order_cnt_lsb_minus4(this.address());
    }

    @NativeType(value="uint8_t")
    public byte sps_max_dec_pic_buffering_minus1() {
        return StdVideoH265SequenceParameterSet.nsps_max_dec_pic_buffering_minus1(this.address());
    }

    @NativeType(value="uint8_t")
    public byte log2_min_luma_coding_block_size_minus3() {
        return StdVideoH265SequenceParameterSet.nlog2_min_luma_coding_block_size_minus3(this.address());
    }

    @NativeType(value="uint8_t")
    public byte log2_diff_max_min_luma_coding_block_size() {
        return StdVideoH265SequenceParameterSet.nlog2_diff_max_min_luma_coding_block_size(this.address());
    }

    @NativeType(value="uint8_t")
    public byte log2_min_luma_transform_block_size_minus2() {
        return StdVideoH265SequenceParameterSet.nlog2_min_luma_transform_block_size_minus2(this.address());
    }

    @NativeType(value="uint8_t")
    public byte log2_diff_max_min_luma_transform_block_size() {
        return StdVideoH265SequenceParameterSet.nlog2_diff_max_min_luma_transform_block_size(this.address());
    }

    @NativeType(value="uint8_t")
    public byte max_transform_hierarchy_depth_inter() {
        return StdVideoH265SequenceParameterSet.nmax_transform_hierarchy_depth_inter(this.address());
    }

    @NativeType(value="uint8_t")
    public byte max_transform_hierarchy_depth_intra() {
        return StdVideoH265SequenceParameterSet.nmax_transform_hierarchy_depth_intra(this.address());
    }

    @NativeType(value="uint8_t")
    public byte num_short_term_ref_pic_sets() {
        return StdVideoH265SequenceParameterSet.nnum_short_term_ref_pic_sets(this.address());
    }

    @NativeType(value="uint8_t")
    public byte num_long_term_ref_pics_sps() {
        return StdVideoH265SequenceParameterSet.nnum_long_term_ref_pics_sps(this.address());
    }

    @NativeType(value="uint8_t")
    public byte pcm_sample_bit_depth_luma_minus1() {
        return StdVideoH265SequenceParameterSet.npcm_sample_bit_depth_luma_minus1(this.address());
    }

    @NativeType(value="uint8_t")
    public byte pcm_sample_bit_depth_chroma_minus1() {
        return StdVideoH265SequenceParameterSet.npcm_sample_bit_depth_chroma_minus1(this.address());
    }

    @NativeType(value="uint8_t")
    public byte log2_min_pcm_luma_coding_block_size_minus3() {
        return StdVideoH265SequenceParameterSet.nlog2_min_pcm_luma_coding_block_size_minus3(this.address());
    }

    @NativeType(value="uint8_t")
    public byte log2_diff_max_min_pcm_luma_coding_block_size() {
        return StdVideoH265SequenceParameterSet.nlog2_diff_max_min_pcm_luma_coding_block_size(this.address());
    }

    @NativeType(value="uint8_t")
    public byte palette_max_size() {
        return StdVideoH265SequenceParameterSet.npalette_max_size(this.address());
    }

    @NativeType(value="uint8_t")
    public byte delta_palette_max_predictor_size() {
        return StdVideoH265SequenceParameterSet.ndelta_palette_max_predictor_size(this.address());
    }

    @NativeType(value="uint8_t")
    public byte motion_vector_resolution_control_idc() {
        return StdVideoH265SequenceParameterSet.nmotion_vector_resolution_control_idc(this.address());
    }

    @NativeType(value="uint8_t")
    public byte sps_num_palette_predictor_initializer_minus1() {
        return StdVideoH265SequenceParameterSet.nsps_num_palette_predictor_initializer_minus1(this.address());
    }

    @NativeType(value="uint32_t")
    public int conf_win_left_offset() {
        return StdVideoH265SequenceParameterSet.nconf_win_left_offset(this.address());
    }

    @NativeType(value="uint32_t")
    public int conf_win_right_offset() {
        return StdVideoH265SequenceParameterSet.nconf_win_right_offset(this.address());
    }

    @NativeType(value="uint32_t")
    public int conf_win_top_offset() {
        return StdVideoH265SequenceParameterSet.nconf_win_top_offset(this.address());
    }

    @NativeType(value="uint32_t")
    public int conf_win_bottom_offset() {
        return StdVideoH265SequenceParameterSet.nconf_win_bottom_offset(this.address());
    }

    @NativeType(value="StdVideoH265ProfileTierLevel const *")
    public StdVideoH265ProfileTierLevel pProfileTierLevel() {
        return StdVideoH265SequenceParameterSet.npProfileTierLevel(this.address());
    }

    @NativeType(value="StdVideoH265DecPicBufMgr const *")
    public StdVideoH265DecPicBufMgr pDecPicBufMgr() {
        return StdVideoH265SequenceParameterSet.npDecPicBufMgr(this.address());
    }

    @NativeType(value="StdVideoH265ScalingLists const *")
    public StdVideoH265ScalingLists pScalingLists() {
        return StdVideoH265SequenceParameterSet.npScalingLists(this.address());
    }

    @NativeType(value="StdVideoH265ShortTermRefPicSet const *")
    public StdVideoH265ShortTermRefPicSet pShortTermRefPicSet() {
        return StdVideoH265SequenceParameterSet.npShortTermRefPicSet(this.address());
    }

    @NativeType(value="StdVideoH265LongTermRefPicsSps const *")
    public StdVideoH265LongTermRefPicsSps pLongTermRefPicsSps() {
        return StdVideoH265SequenceParameterSet.npLongTermRefPicsSps(this.address());
    }

    @NativeType(value="StdVideoH265SequenceParameterSetVui const *")
    public StdVideoH265SequenceParameterSetVui pSequenceParameterSetVui() {
        return StdVideoH265SequenceParameterSet.npSequenceParameterSetVui(this.address());
    }

    @NativeType(value="StdVideoH265PredictorPaletteEntries const *")
    public StdVideoH265PredictorPaletteEntries pPredictorPaletteEntries() {
        return StdVideoH265SequenceParameterSet.npPredictorPaletteEntries(this.address());
    }

    public StdVideoH265SequenceParameterSet flags(StdVideoH265SpsFlags value) {
        StdVideoH265SequenceParameterSet.nflags(this.address(), value);
        return this;
    }

    public StdVideoH265SequenceParameterSet flags(Consumer<StdVideoH265SpsFlags> consumer) {
        consumer.accept(this.flags());
        return this;
    }

    public StdVideoH265SequenceParameterSet chroma_format_idc(@NativeType(value="StdVideoH265ChromaFormatIdc") int value) {
        StdVideoH265SequenceParameterSet.nchroma_format_idc(this.address(), value);
        return this;
    }

    public StdVideoH265SequenceParameterSet pic_width_in_luma_samples(@NativeType(value="uint32_t") int value) {
        StdVideoH265SequenceParameterSet.npic_width_in_luma_samples(this.address(), value);
        return this;
    }

    public StdVideoH265SequenceParameterSet pic_height_in_luma_samples(@NativeType(value="uint32_t") int value) {
        StdVideoH265SequenceParameterSet.npic_height_in_luma_samples(this.address(), value);
        return this;
    }

    public StdVideoH265SequenceParameterSet sps_video_parameter_set_id(@NativeType(value="uint8_t") byte value) {
        StdVideoH265SequenceParameterSet.nsps_video_parameter_set_id(this.address(), value);
        return this;
    }

    public StdVideoH265SequenceParameterSet sps_max_sub_layers_minus1(@NativeType(value="uint8_t") byte value) {
        StdVideoH265SequenceParameterSet.nsps_max_sub_layers_minus1(this.address(), value);
        return this;
    }

    public StdVideoH265SequenceParameterSet sps_seq_parameter_set_id(@NativeType(value="uint8_t") byte value) {
        StdVideoH265SequenceParameterSet.nsps_seq_parameter_set_id(this.address(), value);
        return this;
    }

    public StdVideoH265SequenceParameterSet bit_depth_luma_minus8(@NativeType(value="uint8_t") byte value) {
        StdVideoH265SequenceParameterSet.nbit_depth_luma_minus8(this.address(), value);
        return this;
    }

    public StdVideoH265SequenceParameterSet bit_depth_chroma_minus8(@NativeType(value="uint8_t") byte value) {
        StdVideoH265SequenceParameterSet.nbit_depth_chroma_minus8(this.address(), value);
        return this;
    }

    public StdVideoH265SequenceParameterSet log2_max_pic_order_cnt_lsb_minus4(@NativeType(value="uint8_t") byte value) {
        StdVideoH265SequenceParameterSet.nlog2_max_pic_order_cnt_lsb_minus4(this.address(), value);
        return this;
    }

    public StdVideoH265SequenceParameterSet sps_max_dec_pic_buffering_minus1(@NativeType(value="uint8_t") byte value) {
        StdVideoH265SequenceParameterSet.nsps_max_dec_pic_buffering_minus1(this.address(), value);
        return this;
    }

    public StdVideoH265SequenceParameterSet log2_min_luma_coding_block_size_minus3(@NativeType(value="uint8_t") byte value) {
        StdVideoH265SequenceParameterSet.nlog2_min_luma_coding_block_size_minus3(this.address(), value);
        return this;
    }

    public StdVideoH265SequenceParameterSet log2_diff_max_min_luma_coding_block_size(@NativeType(value="uint8_t") byte value) {
        StdVideoH265SequenceParameterSet.nlog2_diff_max_min_luma_coding_block_size(this.address(), value);
        return this;
    }

    public StdVideoH265SequenceParameterSet log2_min_luma_transform_block_size_minus2(@NativeType(value="uint8_t") byte value) {
        StdVideoH265SequenceParameterSet.nlog2_min_luma_transform_block_size_minus2(this.address(), value);
        return this;
    }

    public StdVideoH265SequenceParameterSet log2_diff_max_min_luma_transform_block_size(@NativeType(value="uint8_t") byte value) {
        StdVideoH265SequenceParameterSet.nlog2_diff_max_min_luma_transform_block_size(this.address(), value);
        return this;
    }

    public StdVideoH265SequenceParameterSet max_transform_hierarchy_depth_inter(@NativeType(value="uint8_t") byte value) {
        StdVideoH265SequenceParameterSet.nmax_transform_hierarchy_depth_inter(this.address(), value);
        return this;
    }

    public StdVideoH265SequenceParameterSet max_transform_hierarchy_depth_intra(@NativeType(value="uint8_t") byte value) {
        StdVideoH265SequenceParameterSet.nmax_transform_hierarchy_depth_intra(this.address(), value);
        return this;
    }

    public StdVideoH265SequenceParameterSet num_short_term_ref_pic_sets(@NativeType(value="uint8_t") byte value) {
        StdVideoH265SequenceParameterSet.nnum_short_term_ref_pic_sets(this.address(), value);
        return this;
    }

    public StdVideoH265SequenceParameterSet num_long_term_ref_pics_sps(@NativeType(value="uint8_t") byte value) {
        StdVideoH265SequenceParameterSet.nnum_long_term_ref_pics_sps(this.address(), value);
        return this;
    }

    public StdVideoH265SequenceParameterSet pcm_sample_bit_depth_luma_minus1(@NativeType(value="uint8_t") byte value) {
        StdVideoH265SequenceParameterSet.npcm_sample_bit_depth_luma_minus1(this.address(), value);
        return this;
    }

    public StdVideoH265SequenceParameterSet pcm_sample_bit_depth_chroma_minus1(@NativeType(value="uint8_t") byte value) {
        StdVideoH265SequenceParameterSet.npcm_sample_bit_depth_chroma_minus1(this.address(), value);
        return this;
    }

    public StdVideoH265SequenceParameterSet log2_min_pcm_luma_coding_block_size_minus3(@NativeType(value="uint8_t") byte value) {
        StdVideoH265SequenceParameterSet.nlog2_min_pcm_luma_coding_block_size_minus3(this.address(), value);
        return this;
    }

    public StdVideoH265SequenceParameterSet log2_diff_max_min_pcm_luma_coding_block_size(@NativeType(value="uint8_t") byte value) {
        StdVideoH265SequenceParameterSet.nlog2_diff_max_min_pcm_luma_coding_block_size(this.address(), value);
        return this;
    }

    public StdVideoH265SequenceParameterSet palette_max_size(@NativeType(value="uint8_t") byte value) {
        StdVideoH265SequenceParameterSet.npalette_max_size(this.address(), value);
        return this;
    }

    public StdVideoH265SequenceParameterSet delta_palette_max_predictor_size(@NativeType(value="uint8_t") byte value) {
        StdVideoH265SequenceParameterSet.ndelta_palette_max_predictor_size(this.address(), value);
        return this;
    }

    public StdVideoH265SequenceParameterSet motion_vector_resolution_control_idc(@NativeType(value="uint8_t") byte value) {
        StdVideoH265SequenceParameterSet.nmotion_vector_resolution_control_idc(this.address(), value);
        return this;
    }

    public StdVideoH265SequenceParameterSet sps_num_palette_predictor_initializer_minus1(@NativeType(value="uint8_t") byte value) {
        StdVideoH265SequenceParameterSet.nsps_num_palette_predictor_initializer_minus1(this.address(), value);
        return this;
    }

    public StdVideoH265SequenceParameterSet conf_win_left_offset(@NativeType(value="uint32_t") int value) {
        StdVideoH265SequenceParameterSet.nconf_win_left_offset(this.address(), value);
        return this;
    }

    public StdVideoH265SequenceParameterSet conf_win_right_offset(@NativeType(value="uint32_t") int value) {
        StdVideoH265SequenceParameterSet.nconf_win_right_offset(this.address(), value);
        return this;
    }

    public StdVideoH265SequenceParameterSet conf_win_top_offset(@NativeType(value="uint32_t") int value) {
        StdVideoH265SequenceParameterSet.nconf_win_top_offset(this.address(), value);
        return this;
    }

    public StdVideoH265SequenceParameterSet conf_win_bottom_offset(@NativeType(value="uint32_t") int value) {
        StdVideoH265SequenceParameterSet.nconf_win_bottom_offset(this.address(), value);
        return this;
    }

    public StdVideoH265SequenceParameterSet pProfileTierLevel(@NativeType(value="StdVideoH265ProfileTierLevel const *") StdVideoH265ProfileTierLevel value) {
        StdVideoH265SequenceParameterSet.npProfileTierLevel(this.address(), value);
        return this;
    }

    public StdVideoH265SequenceParameterSet pDecPicBufMgr(@NativeType(value="StdVideoH265DecPicBufMgr const *") StdVideoH265DecPicBufMgr value) {
        StdVideoH265SequenceParameterSet.npDecPicBufMgr(this.address(), value);
        return this;
    }

    public StdVideoH265SequenceParameterSet pScalingLists(@NativeType(value="StdVideoH265ScalingLists const *") StdVideoH265ScalingLists value) {
        StdVideoH265SequenceParameterSet.npScalingLists(this.address(), value);
        return this;
    }

    public StdVideoH265SequenceParameterSet pShortTermRefPicSet(@NativeType(value="StdVideoH265ShortTermRefPicSet const *") StdVideoH265ShortTermRefPicSet value) {
        StdVideoH265SequenceParameterSet.npShortTermRefPicSet(this.address(), value);
        return this;
    }

    public StdVideoH265SequenceParameterSet pLongTermRefPicsSps(@NativeType(value="StdVideoH265LongTermRefPicsSps const *") StdVideoH265LongTermRefPicsSps value) {
        StdVideoH265SequenceParameterSet.npLongTermRefPicsSps(this.address(), value);
        return this;
    }

    public StdVideoH265SequenceParameterSet pSequenceParameterSetVui(@NativeType(value="StdVideoH265SequenceParameterSetVui const *") StdVideoH265SequenceParameterSetVui value) {
        StdVideoH265SequenceParameterSet.npSequenceParameterSetVui(this.address(), value);
        return this;
    }

    public StdVideoH265SequenceParameterSet pPredictorPaletteEntries(@NativeType(value="StdVideoH265PredictorPaletteEntries const *") StdVideoH265PredictorPaletteEntries value) {
        StdVideoH265SequenceParameterSet.npPredictorPaletteEntries(this.address(), value);
        return this;
    }

    public StdVideoH265SequenceParameterSet set(StdVideoH265SpsFlags flags, int chroma_format_idc, int pic_width_in_luma_samples, int pic_height_in_luma_samples, byte sps_video_parameter_set_id, byte sps_max_sub_layers_minus1, byte sps_seq_parameter_set_id, byte bit_depth_luma_minus8, byte bit_depth_chroma_minus8, byte log2_max_pic_order_cnt_lsb_minus4, byte sps_max_dec_pic_buffering_minus1, byte log2_min_luma_coding_block_size_minus3, byte log2_diff_max_min_luma_coding_block_size, byte log2_min_luma_transform_block_size_minus2, byte log2_diff_max_min_luma_transform_block_size, byte max_transform_hierarchy_depth_inter, byte max_transform_hierarchy_depth_intra, byte num_short_term_ref_pic_sets, byte num_long_term_ref_pics_sps, byte pcm_sample_bit_depth_luma_minus1, byte pcm_sample_bit_depth_chroma_minus1, byte log2_min_pcm_luma_coding_block_size_minus3, byte log2_diff_max_min_pcm_luma_coding_block_size, byte palette_max_size, byte delta_palette_max_predictor_size, byte motion_vector_resolution_control_idc, byte sps_num_palette_predictor_initializer_minus1, int conf_win_left_offset, int conf_win_right_offset, int conf_win_top_offset, int conf_win_bottom_offset, StdVideoH265ProfileTierLevel pProfileTierLevel, StdVideoH265DecPicBufMgr pDecPicBufMgr, StdVideoH265ScalingLists pScalingLists, StdVideoH265ShortTermRefPicSet pShortTermRefPicSet, StdVideoH265LongTermRefPicsSps pLongTermRefPicsSps, StdVideoH265SequenceParameterSetVui pSequenceParameterSetVui, StdVideoH265PredictorPaletteEntries pPredictorPaletteEntries) {
        this.flags(flags);
        this.chroma_format_idc(chroma_format_idc);
        this.pic_width_in_luma_samples(pic_width_in_luma_samples);
        this.pic_height_in_luma_samples(pic_height_in_luma_samples);
        this.sps_video_parameter_set_id(sps_video_parameter_set_id);
        this.sps_max_sub_layers_minus1(sps_max_sub_layers_minus1);
        this.sps_seq_parameter_set_id(sps_seq_parameter_set_id);
        this.bit_depth_luma_minus8(bit_depth_luma_minus8);
        this.bit_depth_chroma_minus8(bit_depth_chroma_minus8);
        this.log2_max_pic_order_cnt_lsb_minus4(log2_max_pic_order_cnt_lsb_minus4);
        this.sps_max_dec_pic_buffering_minus1(sps_max_dec_pic_buffering_minus1);
        this.log2_min_luma_coding_block_size_minus3(log2_min_luma_coding_block_size_minus3);
        this.log2_diff_max_min_luma_coding_block_size(log2_diff_max_min_luma_coding_block_size);
        this.log2_min_luma_transform_block_size_minus2(log2_min_luma_transform_block_size_minus2);
        this.log2_diff_max_min_luma_transform_block_size(log2_diff_max_min_luma_transform_block_size);
        this.max_transform_hierarchy_depth_inter(max_transform_hierarchy_depth_inter);
        this.max_transform_hierarchy_depth_intra(max_transform_hierarchy_depth_intra);
        this.num_short_term_ref_pic_sets(num_short_term_ref_pic_sets);
        this.num_long_term_ref_pics_sps(num_long_term_ref_pics_sps);
        this.pcm_sample_bit_depth_luma_minus1(pcm_sample_bit_depth_luma_minus1);
        this.pcm_sample_bit_depth_chroma_minus1(pcm_sample_bit_depth_chroma_minus1);
        this.log2_min_pcm_luma_coding_block_size_minus3(log2_min_pcm_luma_coding_block_size_minus3);
        this.log2_diff_max_min_pcm_luma_coding_block_size(log2_diff_max_min_pcm_luma_coding_block_size);
        this.palette_max_size(palette_max_size);
        this.delta_palette_max_predictor_size(delta_palette_max_predictor_size);
        this.motion_vector_resolution_control_idc(motion_vector_resolution_control_idc);
        this.sps_num_palette_predictor_initializer_minus1(sps_num_palette_predictor_initializer_minus1);
        this.conf_win_left_offset(conf_win_left_offset);
        this.conf_win_right_offset(conf_win_right_offset);
        this.conf_win_top_offset(conf_win_top_offset);
        this.conf_win_bottom_offset(conf_win_bottom_offset);
        this.pProfileTierLevel(pProfileTierLevel);
        this.pDecPicBufMgr(pDecPicBufMgr);
        this.pScalingLists(pScalingLists);
        this.pShortTermRefPicSet(pShortTermRefPicSet);
        this.pLongTermRefPicsSps(pLongTermRefPicsSps);
        this.pSequenceParameterSetVui(pSequenceParameterSetVui);
        this.pPredictorPaletteEntries(pPredictorPaletteEntries);
        return this;
    }

    public StdVideoH265SequenceParameterSet set(StdVideoH265SequenceParameterSet src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static StdVideoH265SequenceParameterSet malloc() {
        return new StdVideoH265SequenceParameterSet(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static StdVideoH265SequenceParameterSet calloc() {
        return new StdVideoH265SequenceParameterSet(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static StdVideoH265SequenceParameterSet create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new StdVideoH265SequenceParameterSet(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static StdVideoH265SequenceParameterSet create(long address) {
        return new StdVideoH265SequenceParameterSet(address, null);
    }

    public static @Nullable StdVideoH265SequenceParameterSet createSafe(long address) {
        return address == 0L ? null : new StdVideoH265SequenceParameterSet(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)StdVideoH265SequenceParameterSet.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = StdVideoH265SequenceParameterSet.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static StdVideoH265SequenceParameterSet malloc(MemoryStack stack) {
        return new StdVideoH265SequenceParameterSet(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static StdVideoH265SequenceParameterSet calloc(MemoryStack stack) {
        return new StdVideoH265SequenceParameterSet(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static StdVideoH265SpsFlags nflags(long struct) {
        return StdVideoH265SpsFlags.create(struct + (long)FLAGS);
    }

    public static int nchroma_format_idc(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)CHROMA_FORMAT_IDC));
    }

    public static int npic_width_in_luma_samples(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)PIC_WIDTH_IN_LUMA_SAMPLES));
    }

    public static int npic_height_in_luma_samples(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)PIC_HEIGHT_IN_LUMA_SAMPLES));
    }

    public static byte nsps_video_parameter_set_id(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)SPS_VIDEO_PARAMETER_SET_ID));
    }

    public static byte nsps_max_sub_layers_minus1(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)SPS_MAX_SUB_LAYERS_MINUS1));
    }

    public static byte nsps_seq_parameter_set_id(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)SPS_SEQ_PARAMETER_SET_ID));
    }

    public static byte nbit_depth_luma_minus8(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)BIT_DEPTH_LUMA_MINUS8));
    }

    public static byte nbit_depth_chroma_minus8(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)BIT_DEPTH_CHROMA_MINUS8));
    }

    public static byte nlog2_max_pic_order_cnt_lsb_minus4(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)LOG2_MAX_PIC_ORDER_CNT_LSB_MINUS4));
    }

    public static byte nsps_max_dec_pic_buffering_minus1(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)SPS_MAX_DEC_PIC_BUFFERING_MINUS1));
    }

    public static byte nlog2_min_luma_coding_block_size_minus3(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)LOG2_MIN_LUMA_CODING_BLOCK_SIZE_MINUS3));
    }

    public static byte nlog2_diff_max_min_luma_coding_block_size(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)LOG2_DIFF_MAX_MIN_LUMA_CODING_BLOCK_SIZE));
    }

    public static byte nlog2_min_luma_transform_block_size_minus2(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)LOG2_MIN_LUMA_TRANSFORM_BLOCK_SIZE_MINUS2));
    }

    public static byte nlog2_diff_max_min_luma_transform_block_size(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)LOG2_DIFF_MAX_MIN_LUMA_TRANSFORM_BLOCK_SIZE));
    }

    public static byte nmax_transform_hierarchy_depth_inter(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)MAX_TRANSFORM_HIERARCHY_DEPTH_INTER));
    }

    public static byte nmax_transform_hierarchy_depth_intra(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)MAX_TRANSFORM_HIERARCHY_DEPTH_INTRA));
    }

    public static byte nnum_short_term_ref_pic_sets(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)NUM_SHORT_TERM_REF_PIC_SETS));
    }

    public static byte nnum_long_term_ref_pics_sps(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)NUM_LONG_TERM_REF_PICS_SPS));
    }

    public static byte npcm_sample_bit_depth_luma_minus1(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)PCM_SAMPLE_BIT_DEPTH_LUMA_MINUS1));
    }

    public static byte npcm_sample_bit_depth_chroma_minus1(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)PCM_SAMPLE_BIT_DEPTH_CHROMA_MINUS1));
    }

    public static byte nlog2_min_pcm_luma_coding_block_size_minus3(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)LOG2_MIN_PCM_LUMA_CODING_BLOCK_SIZE_MINUS3));
    }

    public static byte nlog2_diff_max_min_pcm_luma_coding_block_size(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)LOG2_DIFF_MAX_MIN_PCM_LUMA_CODING_BLOCK_SIZE));
    }

    public static byte nreserved1(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)RESERVED1));
    }

    public static byte nreserved2(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)RESERVED2));
    }

    public static byte npalette_max_size(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)PALETTE_MAX_SIZE));
    }

    public static byte ndelta_palette_max_predictor_size(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)DELTA_PALETTE_MAX_PREDICTOR_SIZE));
    }

    public static byte nmotion_vector_resolution_control_idc(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)MOTION_VECTOR_RESOLUTION_CONTROL_IDC));
    }

    public static byte nsps_num_palette_predictor_initializer_minus1(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)SPS_NUM_PALETTE_PREDICTOR_INITIALIZER_MINUS1));
    }

    public static int nconf_win_left_offset(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)CONF_WIN_LEFT_OFFSET));
    }

    public static int nconf_win_right_offset(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)CONF_WIN_RIGHT_OFFSET));
    }

    public static int nconf_win_top_offset(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)CONF_WIN_TOP_OFFSET));
    }

    public static int nconf_win_bottom_offset(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)CONF_WIN_BOTTOM_OFFSET));
    }

    public static StdVideoH265ProfileTierLevel npProfileTierLevel(long struct) {
        return StdVideoH265ProfileTierLevel.create(MemoryUtil.memGetAddress((long)(struct + (long)PPROFILETIERLEVEL)));
    }

    public static StdVideoH265DecPicBufMgr npDecPicBufMgr(long struct) {
        return StdVideoH265DecPicBufMgr.create(MemoryUtil.memGetAddress((long)(struct + (long)PDECPICBUFMGR)));
    }

    public static StdVideoH265ScalingLists npScalingLists(long struct) {
        return StdVideoH265ScalingLists.create(MemoryUtil.memGetAddress((long)(struct + (long)PSCALINGLISTS)));
    }

    public static StdVideoH265ShortTermRefPicSet npShortTermRefPicSet(long struct) {
        return StdVideoH265ShortTermRefPicSet.create(MemoryUtil.memGetAddress((long)(struct + (long)PSHORTTERMREFPICSET)));
    }

    public static StdVideoH265LongTermRefPicsSps npLongTermRefPicsSps(long struct) {
        return StdVideoH265LongTermRefPicsSps.create(MemoryUtil.memGetAddress((long)(struct + (long)PLONGTERMREFPICSSPS)));
    }

    public static StdVideoH265SequenceParameterSetVui npSequenceParameterSetVui(long struct) {
        return StdVideoH265SequenceParameterSetVui.create(MemoryUtil.memGetAddress((long)(struct + (long)PSEQUENCEPARAMETERSETVUI)));
    }

    public static StdVideoH265PredictorPaletteEntries npPredictorPaletteEntries(long struct) {
        return StdVideoH265PredictorPaletteEntries.create(MemoryUtil.memGetAddress((long)(struct + (long)PPREDICTORPALETTEENTRIES)));
    }

    public static void nflags(long struct, StdVideoH265SpsFlags value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)FLAGS), (long)StdVideoH265SpsFlags.SIZEOF);
    }

    public static void nchroma_format_idc(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)CHROMA_FORMAT_IDC), (int)value);
    }

    public static void npic_width_in_luma_samples(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)PIC_WIDTH_IN_LUMA_SAMPLES), (int)value);
    }

    public static void npic_height_in_luma_samples(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)PIC_HEIGHT_IN_LUMA_SAMPLES), (int)value);
    }

    public static void nsps_video_parameter_set_id(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)SPS_VIDEO_PARAMETER_SET_ID), (byte)value);
    }

    public static void nsps_max_sub_layers_minus1(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)SPS_MAX_SUB_LAYERS_MINUS1), (byte)value);
    }

    public static void nsps_seq_parameter_set_id(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)SPS_SEQ_PARAMETER_SET_ID), (byte)value);
    }

    public static void nbit_depth_luma_minus8(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)BIT_DEPTH_LUMA_MINUS8), (byte)value);
    }

    public static void nbit_depth_chroma_minus8(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)BIT_DEPTH_CHROMA_MINUS8), (byte)value);
    }

    public static void nlog2_max_pic_order_cnt_lsb_minus4(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)LOG2_MAX_PIC_ORDER_CNT_LSB_MINUS4), (byte)value);
    }

    public static void nsps_max_dec_pic_buffering_minus1(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)SPS_MAX_DEC_PIC_BUFFERING_MINUS1), (byte)value);
    }

    public static void nlog2_min_luma_coding_block_size_minus3(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)LOG2_MIN_LUMA_CODING_BLOCK_SIZE_MINUS3), (byte)value);
    }

    public static void nlog2_diff_max_min_luma_coding_block_size(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)LOG2_DIFF_MAX_MIN_LUMA_CODING_BLOCK_SIZE), (byte)value);
    }

    public static void nlog2_min_luma_transform_block_size_minus2(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)LOG2_MIN_LUMA_TRANSFORM_BLOCK_SIZE_MINUS2), (byte)value);
    }

    public static void nlog2_diff_max_min_luma_transform_block_size(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)LOG2_DIFF_MAX_MIN_LUMA_TRANSFORM_BLOCK_SIZE), (byte)value);
    }

    public static void nmax_transform_hierarchy_depth_inter(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)MAX_TRANSFORM_HIERARCHY_DEPTH_INTER), (byte)value);
    }

    public static void nmax_transform_hierarchy_depth_intra(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)MAX_TRANSFORM_HIERARCHY_DEPTH_INTRA), (byte)value);
    }

    public static void nnum_short_term_ref_pic_sets(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)NUM_SHORT_TERM_REF_PIC_SETS), (byte)value);
    }

    public static void nnum_long_term_ref_pics_sps(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)NUM_LONG_TERM_REF_PICS_SPS), (byte)value);
    }

    public static void npcm_sample_bit_depth_luma_minus1(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)PCM_SAMPLE_BIT_DEPTH_LUMA_MINUS1), (byte)value);
    }

    public static void npcm_sample_bit_depth_chroma_minus1(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)PCM_SAMPLE_BIT_DEPTH_CHROMA_MINUS1), (byte)value);
    }

    public static void nlog2_min_pcm_luma_coding_block_size_minus3(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)LOG2_MIN_PCM_LUMA_CODING_BLOCK_SIZE_MINUS3), (byte)value);
    }

    public static void nlog2_diff_max_min_pcm_luma_coding_block_size(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)LOG2_DIFF_MAX_MIN_PCM_LUMA_CODING_BLOCK_SIZE), (byte)value);
    }

    public static void nreserved1(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)RESERVED1), (byte)value);
    }

    public static void nreserved2(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)RESERVED2), (byte)value);
    }

    public static void npalette_max_size(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)PALETTE_MAX_SIZE), (byte)value);
    }

    public static void ndelta_palette_max_predictor_size(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)DELTA_PALETTE_MAX_PREDICTOR_SIZE), (byte)value);
    }

    public static void nmotion_vector_resolution_control_idc(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)MOTION_VECTOR_RESOLUTION_CONTROL_IDC), (byte)value);
    }

    public static void nsps_num_palette_predictor_initializer_minus1(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)SPS_NUM_PALETTE_PREDICTOR_INITIALIZER_MINUS1), (byte)value);
    }

    public static void nconf_win_left_offset(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)CONF_WIN_LEFT_OFFSET), (int)value);
    }

    public static void nconf_win_right_offset(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)CONF_WIN_RIGHT_OFFSET), (int)value);
    }

    public static void nconf_win_top_offset(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)CONF_WIN_TOP_OFFSET), (int)value);
    }

    public static void nconf_win_bottom_offset(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)CONF_WIN_BOTTOM_OFFSET), (int)value);
    }

    public static void npProfileTierLevel(long struct, StdVideoH265ProfileTierLevel value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PPROFILETIERLEVEL), (long)value.address());
    }

    public static void npDecPicBufMgr(long struct, StdVideoH265DecPicBufMgr value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PDECPICBUFMGR), (long)value.address());
    }

    public static void npScalingLists(long struct, StdVideoH265ScalingLists value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PSCALINGLISTS), (long)value.address());
    }

    public static void npShortTermRefPicSet(long struct, StdVideoH265ShortTermRefPicSet value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PSHORTTERMREFPICSET), (long)value.address());
    }

    public static void npLongTermRefPicsSps(long struct, StdVideoH265LongTermRefPicsSps value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PLONGTERMREFPICSSPS), (long)value.address());
    }

    public static void npSequenceParameterSetVui(long struct, StdVideoH265SequenceParameterSetVui value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PSEQUENCEPARAMETERSETVUI), (long)value.address());
    }

    public static void npPredictorPaletteEntries(long struct, StdVideoH265PredictorPaletteEntries value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PPREDICTORPALETTEENTRIES), (long)value.address());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PPROFILETIERLEVEL)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PDECPICBUFMGR)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PSCALINGLISTS)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PSHORTTERMREFPICSET)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PLONGTERMREFPICSSPS)));
        long pSequenceParameterSetVui = MemoryUtil.memGetAddress((long)(struct + (long)PSEQUENCEPARAMETERSETVUI));
        Checks.check((long)pSequenceParameterSetVui);
        StdVideoH265SequenceParameterSetVui.validate(pSequenceParameterSetVui);
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PPREDICTORPALETTEENTRIES)));
    }

    static {
        Struct.Layout layout = StdVideoH265SequenceParameterSet.__struct((Struct.Member[])new Struct.Member[]{StdVideoH265SequenceParameterSet.__member((int)StdVideoH265SpsFlags.SIZEOF, (int)StdVideoH265SpsFlags.ALIGNOF), StdVideoH265SequenceParameterSet.__member((int)4), StdVideoH265SequenceParameterSet.__member((int)4), StdVideoH265SequenceParameterSet.__member((int)4), StdVideoH265SequenceParameterSet.__member((int)1), StdVideoH265SequenceParameterSet.__member((int)1), StdVideoH265SequenceParameterSet.__member((int)1), StdVideoH265SequenceParameterSet.__member((int)1), StdVideoH265SequenceParameterSet.__member((int)1), StdVideoH265SequenceParameterSet.__member((int)1), StdVideoH265SequenceParameterSet.__member((int)1), StdVideoH265SequenceParameterSet.__member((int)1), StdVideoH265SequenceParameterSet.__member((int)1), StdVideoH265SequenceParameterSet.__member((int)1), StdVideoH265SequenceParameterSet.__member((int)1), StdVideoH265SequenceParameterSet.__member((int)1), StdVideoH265SequenceParameterSet.__member((int)1), StdVideoH265SequenceParameterSet.__member((int)1), StdVideoH265SequenceParameterSet.__member((int)1), StdVideoH265SequenceParameterSet.__member((int)1), StdVideoH265SequenceParameterSet.__member((int)1), StdVideoH265SequenceParameterSet.__member((int)1), StdVideoH265SequenceParameterSet.__member((int)1), StdVideoH265SequenceParameterSet.__member((int)1), StdVideoH265SequenceParameterSet.__member((int)1), StdVideoH265SequenceParameterSet.__member((int)1), StdVideoH265SequenceParameterSet.__member((int)1), StdVideoH265SequenceParameterSet.__member((int)1), StdVideoH265SequenceParameterSet.__member((int)1), StdVideoH265SequenceParameterSet.__member((int)4), StdVideoH265SequenceParameterSet.__member((int)4), StdVideoH265SequenceParameterSet.__member((int)4), StdVideoH265SequenceParameterSet.__member((int)4), StdVideoH265SequenceParameterSet.__member((int)POINTER_SIZE), StdVideoH265SequenceParameterSet.__member((int)POINTER_SIZE), StdVideoH265SequenceParameterSet.__member((int)POINTER_SIZE), StdVideoH265SequenceParameterSet.__member((int)POINTER_SIZE), StdVideoH265SequenceParameterSet.__member((int)POINTER_SIZE), StdVideoH265SequenceParameterSet.__member((int)POINTER_SIZE), StdVideoH265SequenceParameterSet.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        CHROMA_FORMAT_IDC = layout.offsetof(1);
        PIC_WIDTH_IN_LUMA_SAMPLES = layout.offsetof(2);
        PIC_HEIGHT_IN_LUMA_SAMPLES = layout.offsetof(3);
        SPS_VIDEO_PARAMETER_SET_ID = layout.offsetof(4);
        SPS_MAX_SUB_LAYERS_MINUS1 = layout.offsetof(5);
        SPS_SEQ_PARAMETER_SET_ID = layout.offsetof(6);
        BIT_DEPTH_LUMA_MINUS8 = layout.offsetof(7);
        BIT_DEPTH_CHROMA_MINUS8 = layout.offsetof(8);
        LOG2_MAX_PIC_ORDER_CNT_LSB_MINUS4 = layout.offsetof(9);
        SPS_MAX_DEC_PIC_BUFFERING_MINUS1 = layout.offsetof(10);
        LOG2_MIN_LUMA_CODING_BLOCK_SIZE_MINUS3 = layout.offsetof(11);
        LOG2_DIFF_MAX_MIN_LUMA_CODING_BLOCK_SIZE = layout.offsetof(12);
        LOG2_MIN_LUMA_TRANSFORM_BLOCK_SIZE_MINUS2 = layout.offsetof(13);
        LOG2_DIFF_MAX_MIN_LUMA_TRANSFORM_BLOCK_SIZE = layout.offsetof(14);
        MAX_TRANSFORM_HIERARCHY_DEPTH_INTER = layout.offsetof(15);
        MAX_TRANSFORM_HIERARCHY_DEPTH_INTRA = layout.offsetof(16);
        NUM_SHORT_TERM_REF_PIC_SETS = layout.offsetof(17);
        NUM_LONG_TERM_REF_PICS_SPS = layout.offsetof(18);
        PCM_SAMPLE_BIT_DEPTH_LUMA_MINUS1 = layout.offsetof(19);
        PCM_SAMPLE_BIT_DEPTH_CHROMA_MINUS1 = layout.offsetof(20);
        LOG2_MIN_PCM_LUMA_CODING_BLOCK_SIZE_MINUS3 = layout.offsetof(21);
        LOG2_DIFF_MAX_MIN_PCM_LUMA_CODING_BLOCK_SIZE = layout.offsetof(22);
        RESERVED1 = layout.offsetof(23);
        RESERVED2 = layout.offsetof(24);
        PALETTE_MAX_SIZE = layout.offsetof(25);
        DELTA_PALETTE_MAX_PREDICTOR_SIZE = layout.offsetof(26);
        MOTION_VECTOR_RESOLUTION_CONTROL_IDC = layout.offsetof(27);
        SPS_NUM_PALETTE_PREDICTOR_INITIALIZER_MINUS1 = layout.offsetof(28);
        CONF_WIN_LEFT_OFFSET = layout.offsetof(29);
        CONF_WIN_RIGHT_OFFSET = layout.offsetof(30);
        CONF_WIN_TOP_OFFSET = layout.offsetof(31);
        CONF_WIN_BOTTOM_OFFSET = layout.offsetof(32);
        PPROFILETIERLEVEL = layout.offsetof(33);
        PDECPICBUFMGR = layout.offsetof(34);
        PSCALINGLISTS = layout.offsetof(35);
        PSHORTTERMREFPICSET = layout.offsetof(36);
        PLONGTERMREFPICSSPS = layout.offsetof(37);
        PSEQUENCEPARAMETERSETVUI = layout.offsetof(38);
        PPREDICTORPALETTEENTRIES = layout.offsetof(39);
    }

    public static class Buffer
    extends StructBuffer<StdVideoH265SequenceParameterSet, Buffer>
    implements NativeResource {
        private static final StdVideoH265SequenceParameterSet ELEMENT_FACTORY = StdVideoH265SequenceParameterSet.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected StdVideoH265SequenceParameterSet getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public StdVideoH265SpsFlags flags() {
            return StdVideoH265SequenceParameterSet.nflags(this.address());
        }

        @NativeType(value="StdVideoH265ChromaFormatIdc")
        public int chroma_format_idc() {
            return StdVideoH265SequenceParameterSet.nchroma_format_idc(this.address());
        }

        @NativeType(value="uint32_t")
        public int pic_width_in_luma_samples() {
            return StdVideoH265SequenceParameterSet.npic_width_in_luma_samples(this.address());
        }

        @NativeType(value="uint32_t")
        public int pic_height_in_luma_samples() {
            return StdVideoH265SequenceParameterSet.npic_height_in_luma_samples(this.address());
        }

        @NativeType(value="uint8_t")
        public byte sps_video_parameter_set_id() {
            return StdVideoH265SequenceParameterSet.nsps_video_parameter_set_id(this.address());
        }

        @NativeType(value="uint8_t")
        public byte sps_max_sub_layers_minus1() {
            return StdVideoH265SequenceParameterSet.nsps_max_sub_layers_minus1(this.address());
        }

        @NativeType(value="uint8_t")
        public byte sps_seq_parameter_set_id() {
            return StdVideoH265SequenceParameterSet.nsps_seq_parameter_set_id(this.address());
        }

        @NativeType(value="uint8_t")
        public byte bit_depth_luma_minus8() {
            return StdVideoH265SequenceParameterSet.nbit_depth_luma_minus8(this.address());
        }

        @NativeType(value="uint8_t")
        public byte bit_depth_chroma_minus8() {
            return StdVideoH265SequenceParameterSet.nbit_depth_chroma_minus8(this.address());
        }

        @NativeType(value="uint8_t")
        public byte log2_max_pic_order_cnt_lsb_minus4() {
            return StdVideoH265SequenceParameterSet.nlog2_max_pic_order_cnt_lsb_minus4(this.address());
        }

        @NativeType(value="uint8_t")
        public byte sps_max_dec_pic_buffering_minus1() {
            return StdVideoH265SequenceParameterSet.nsps_max_dec_pic_buffering_minus1(this.address());
        }

        @NativeType(value="uint8_t")
        public byte log2_min_luma_coding_block_size_minus3() {
            return StdVideoH265SequenceParameterSet.nlog2_min_luma_coding_block_size_minus3(this.address());
        }

        @NativeType(value="uint8_t")
        public byte log2_diff_max_min_luma_coding_block_size() {
            return StdVideoH265SequenceParameterSet.nlog2_diff_max_min_luma_coding_block_size(this.address());
        }

        @NativeType(value="uint8_t")
        public byte log2_min_luma_transform_block_size_minus2() {
            return StdVideoH265SequenceParameterSet.nlog2_min_luma_transform_block_size_minus2(this.address());
        }

        @NativeType(value="uint8_t")
        public byte log2_diff_max_min_luma_transform_block_size() {
            return StdVideoH265SequenceParameterSet.nlog2_diff_max_min_luma_transform_block_size(this.address());
        }

        @NativeType(value="uint8_t")
        public byte max_transform_hierarchy_depth_inter() {
            return StdVideoH265SequenceParameterSet.nmax_transform_hierarchy_depth_inter(this.address());
        }

        @NativeType(value="uint8_t")
        public byte max_transform_hierarchy_depth_intra() {
            return StdVideoH265SequenceParameterSet.nmax_transform_hierarchy_depth_intra(this.address());
        }

        @NativeType(value="uint8_t")
        public byte num_short_term_ref_pic_sets() {
            return StdVideoH265SequenceParameterSet.nnum_short_term_ref_pic_sets(this.address());
        }

        @NativeType(value="uint8_t")
        public byte num_long_term_ref_pics_sps() {
            return StdVideoH265SequenceParameterSet.nnum_long_term_ref_pics_sps(this.address());
        }

        @NativeType(value="uint8_t")
        public byte pcm_sample_bit_depth_luma_minus1() {
            return StdVideoH265SequenceParameterSet.npcm_sample_bit_depth_luma_minus1(this.address());
        }

        @NativeType(value="uint8_t")
        public byte pcm_sample_bit_depth_chroma_minus1() {
            return StdVideoH265SequenceParameterSet.npcm_sample_bit_depth_chroma_minus1(this.address());
        }

        @NativeType(value="uint8_t")
        public byte log2_min_pcm_luma_coding_block_size_minus3() {
            return StdVideoH265SequenceParameterSet.nlog2_min_pcm_luma_coding_block_size_minus3(this.address());
        }

        @NativeType(value="uint8_t")
        public byte log2_diff_max_min_pcm_luma_coding_block_size() {
            return StdVideoH265SequenceParameterSet.nlog2_diff_max_min_pcm_luma_coding_block_size(this.address());
        }

        @NativeType(value="uint8_t")
        public byte palette_max_size() {
            return StdVideoH265SequenceParameterSet.npalette_max_size(this.address());
        }

        @NativeType(value="uint8_t")
        public byte delta_palette_max_predictor_size() {
            return StdVideoH265SequenceParameterSet.ndelta_palette_max_predictor_size(this.address());
        }

        @NativeType(value="uint8_t")
        public byte motion_vector_resolution_control_idc() {
            return StdVideoH265SequenceParameterSet.nmotion_vector_resolution_control_idc(this.address());
        }

        @NativeType(value="uint8_t")
        public byte sps_num_palette_predictor_initializer_minus1() {
            return StdVideoH265SequenceParameterSet.nsps_num_palette_predictor_initializer_minus1(this.address());
        }

        @NativeType(value="uint32_t")
        public int conf_win_left_offset() {
            return StdVideoH265SequenceParameterSet.nconf_win_left_offset(this.address());
        }

        @NativeType(value="uint32_t")
        public int conf_win_right_offset() {
            return StdVideoH265SequenceParameterSet.nconf_win_right_offset(this.address());
        }

        @NativeType(value="uint32_t")
        public int conf_win_top_offset() {
            return StdVideoH265SequenceParameterSet.nconf_win_top_offset(this.address());
        }

        @NativeType(value="uint32_t")
        public int conf_win_bottom_offset() {
            return StdVideoH265SequenceParameterSet.nconf_win_bottom_offset(this.address());
        }

        @NativeType(value="StdVideoH265ProfileTierLevel const *")
        public StdVideoH265ProfileTierLevel pProfileTierLevel() {
            return StdVideoH265SequenceParameterSet.npProfileTierLevel(this.address());
        }

        @NativeType(value="StdVideoH265DecPicBufMgr const *")
        public StdVideoH265DecPicBufMgr pDecPicBufMgr() {
            return StdVideoH265SequenceParameterSet.npDecPicBufMgr(this.address());
        }

        @NativeType(value="StdVideoH265ScalingLists const *")
        public StdVideoH265ScalingLists pScalingLists() {
            return StdVideoH265SequenceParameterSet.npScalingLists(this.address());
        }

        @NativeType(value="StdVideoH265ShortTermRefPicSet const *")
        public StdVideoH265ShortTermRefPicSet pShortTermRefPicSet() {
            return StdVideoH265SequenceParameterSet.npShortTermRefPicSet(this.address());
        }

        @NativeType(value="StdVideoH265LongTermRefPicsSps const *")
        public StdVideoH265LongTermRefPicsSps pLongTermRefPicsSps() {
            return StdVideoH265SequenceParameterSet.npLongTermRefPicsSps(this.address());
        }

        @NativeType(value="StdVideoH265SequenceParameterSetVui const *")
        public StdVideoH265SequenceParameterSetVui pSequenceParameterSetVui() {
            return StdVideoH265SequenceParameterSet.npSequenceParameterSetVui(this.address());
        }

        @NativeType(value="StdVideoH265PredictorPaletteEntries const *")
        public StdVideoH265PredictorPaletteEntries pPredictorPaletteEntries() {
            return StdVideoH265SequenceParameterSet.npPredictorPaletteEntries(this.address());
        }

        public Buffer flags(StdVideoH265SpsFlags value) {
            StdVideoH265SequenceParameterSet.nflags(this.address(), value);
            return this;
        }

        public Buffer flags(Consumer<StdVideoH265SpsFlags> consumer) {
            consumer.accept(this.flags());
            return this;
        }

        public Buffer chroma_format_idc(@NativeType(value="StdVideoH265ChromaFormatIdc") int value) {
            StdVideoH265SequenceParameterSet.nchroma_format_idc(this.address(), value);
            return this;
        }

        public Buffer pic_width_in_luma_samples(@NativeType(value="uint32_t") int value) {
            StdVideoH265SequenceParameterSet.npic_width_in_luma_samples(this.address(), value);
            return this;
        }

        public Buffer pic_height_in_luma_samples(@NativeType(value="uint32_t") int value) {
            StdVideoH265SequenceParameterSet.npic_height_in_luma_samples(this.address(), value);
            return this;
        }

        public Buffer sps_video_parameter_set_id(@NativeType(value="uint8_t") byte value) {
            StdVideoH265SequenceParameterSet.nsps_video_parameter_set_id(this.address(), value);
            return this;
        }

        public Buffer sps_max_sub_layers_minus1(@NativeType(value="uint8_t") byte value) {
            StdVideoH265SequenceParameterSet.nsps_max_sub_layers_minus1(this.address(), value);
            return this;
        }

        public Buffer sps_seq_parameter_set_id(@NativeType(value="uint8_t") byte value) {
            StdVideoH265SequenceParameterSet.nsps_seq_parameter_set_id(this.address(), value);
            return this;
        }

        public Buffer bit_depth_luma_minus8(@NativeType(value="uint8_t") byte value) {
            StdVideoH265SequenceParameterSet.nbit_depth_luma_minus8(this.address(), value);
            return this;
        }

        public Buffer bit_depth_chroma_minus8(@NativeType(value="uint8_t") byte value) {
            StdVideoH265SequenceParameterSet.nbit_depth_chroma_minus8(this.address(), value);
            return this;
        }

        public Buffer log2_max_pic_order_cnt_lsb_minus4(@NativeType(value="uint8_t") byte value) {
            StdVideoH265SequenceParameterSet.nlog2_max_pic_order_cnt_lsb_minus4(this.address(), value);
            return this;
        }

        public Buffer sps_max_dec_pic_buffering_minus1(@NativeType(value="uint8_t") byte value) {
            StdVideoH265SequenceParameterSet.nsps_max_dec_pic_buffering_minus1(this.address(), value);
            return this;
        }

        public Buffer log2_min_luma_coding_block_size_minus3(@NativeType(value="uint8_t") byte value) {
            StdVideoH265SequenceParameterSet.nlog2_min_luma_coding_block_size_minus3(this.address(), value);
            return this;
        }

        public Buffer log2_diff_max_min_luma_coding_block_size(@NativeType(value="uint8_t") byte value) {
            StdVideoH265SequenceParameterSet.nlog2_diff_max_min_luma_coding_block_size(this.address(), value);
            return this;
        }

        public Buffer log2_min_luma_transform_block_size_minus2(@NativeType(value="uint8_t") byte value) {
            StdVideoH265SequenceParameterSet.nlog2_min_luma_transform_block_size_minus2(this.address(), value);
            return this;
        }

        public Buffer log2_diff_max_min_luma_transform_block_size(@NativeType(value="uint8_t") byte value) {
            StdVideoH265SequenceParameterSet.nlog2_diff_max_min_luma_transform_block_size(this.address(), value);
            return this;
        }

        public Buffer max_transform_hierarchy_depth_inter(@NativeType(value="uint8_t") byte value) {
            StdVideoH265SequenceParameterSet.nmax_transform_hierarchy_depth_inter(this.address(), value);
            return this;
        }

        public Buffer max_transform_hierarchy_depth_intra(@NativeType(value="uint8_t") byte value) {
            StdVideoH265SequenceParameterSet.nmax_transform_hierarchy_depth_intra(this.address(), value);
            return this;
        }

        public Buffer num_short_term_ref_pic_sets(@NativeType(value="uint8_t") byte value) {
            StdVideoH265SequenceParameterSet.nnum_short_term_ref_pic_sets(this.address(), value);
            return this;
        }

        public Buffer num_long_term_ref_pics_sps(@NativeType(value="uint8_t") byte value) {
            StdVideoH265SequenceParameterSet.nnum_long_term_ref_pics_sps(this.address(), value);
            return this;
        }

        public Buffer pcm_sample_bit_depth_luma_minus1(@NativeType(value="uint8_t") byte value) {
            StdVideoH265SequenceParameterSet.npcm_sample_bit_depth_luma_minus1(this.address(), value);
            return this;
        }

        public Buffer pcm_sample_bit_depth_chroma_minus1(@NativeType(value="uint8_t") byte value) {
            StdVideoH265SequenceParameterSet.npcm_sample_bit_depth_chroma_minus1(this.address(), value);
            return this;
        }

        public Buffer log2_min_pcm_luma_coding_block_size_minus3(@NativeType(value="uint8_t") byte value) {
            StdVideoH265SequenceParameterSet.nlog2_min_pcm_luma_coding_block_size_minus3(this.address(), value);
            return this;
        }

        public Buffer log2_diff_max_min_pcm_luma_coding_block_size(@NativeType(value="uint8_t") byte value) {
            StdVideoH265SequenceParameterSet.nlog2_diff_max_min_pcm_luma_coding_block_size(this.address(), value);
            return this;
        }

        public Buffer palette_max_size(@NativeType(value="uint8_t") byte value) {
            StdVideoH265SequenceParameterSet.npalette_max_size(this.address(), value);
            return this;
        }

        public Buffer delta_palette_max_predictor_size(@NativeType(value="uint8_t") byte value) {
            StdVideoH265SequenceParameterSet.ndelta_palette_max_predictor_size(this.address(), value);
            return this;
        }

        public Buffer motion_vector_resolution_control_idc(@NativeType(value="uint8_t") byte value) {
            StdVideoH265SequenceParameterSet.nmotion_vector_resolution_control_idc(this.address(), value);
            return this;
        }

        public Buffer sps_num_palette_predictor_initializer_minus1(@NativeType(value="uint8_t") byte value) {
            StdVideoH265SequenceParameterSet.nsps_num_palette_predictor_initializer_minus1(this.address(), value);
            return this;
        }

        public Buffer conf_win_left_offset(@NativeType(value="uint32_t") int value) {
            StdVideoH265SequenceParameterSet.nconf_win_left_offset(this.address(), value);
            return this;
        }

        public Buffer conf_win_right_offset(@NativeType(value="uint32_t") int value) {
            StdVideoH265SequenceParameterSet.nconf_win_right_offset(this.address(), value);
            return this;
        }

        public Buffer conf_win_top_offset(@NativeType(value="uint32_t") int value) {
            StdVideoH265SequenceParameterSet.nconf_win_top_offset(this.address(), value);
            return this;
        }

        public Buffer conf_win_bottom_offset(@NativeType(value="uint32_t") int value) {
            StdVideoH265SequenceParameterSet.nconf_win_bottom_offset(this.address(), value);
            return this;
        }

        public Buffer pProfileTierLevel(@NativeType(value="StdVideoH265ProfileTierLevel const *") StdVideoH265ProfileTierLevel value) {
            StdVideoH265SequenceParameterSet.npProfileTierLevel(this.address(), value);
            return this;
        }

        public Buffer pDecPicBufMgr(@NativeType(value="StdVideoH265DecPicBufMgr const *") StdVideoH265DecPicBufMgr value) {
            StdVideoH265SequenceParameterSet.npDecPicBufMgr(this.address(), value);
            return this;
        }

        public Buffer pScalingLists(@NativeType(value="StdVideoH265ScalingLists const *") StdVideoH265ScalingLists value) {
            StdVideoH265SequenceParameterSet.npScalingLists(this.address(), value);
            return this;
        }

        public Buffer pShortTermRefPicSet(@NativeType(value="StdVideoH265ShortTermRefPicSet const *") StdVideoH265ShortTermRefPicSet value) {
            StdVideoH265SequenceParameterSet.npShortTermRefPicSet(this.address(), value);
            return this;
        }

        public Buffer pLongTermRefPicsSps(@NativeType(value="StdVideoH265LongTermRefPicsSps const *") StdVideoH265LongTermRefPicsSps value) {
            StdVideoH265SequenceParameterSet.npLongTermRefPicsSps(this.address(), value);
            return this;
        }

        public Buffer pSequenceParameterSetVui(@NativeType(value="StdVideoH265SequenceParameterSetVui const *") StdVideoH265SequenceParameterSetVui value) {
            StdVideoH265SequenceParameterSet.npSequenceParameterSetVui(this.address(), value);
            return this;
        }

        public Buffer pPredictorPaletteEntries(@NativeType(value="StdVideoH265PredictorPaletteEntries const *") StdVideoH265PredictorPaletteEntries value) {
            StdVideoH265SequenceParameterSet.npPredictorPaletteEntries(this.address(), value);
            return this;
        }
    }
}

