/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.zstd;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.zstd.ZDICTParams;

@NativeType(value="struct ZDICT_fastCover_params_t")
public class ZDICTFastCoverParams
extends Struct<ZDICTFastCoverParams>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int K;
    public static final int D;
    public static final int F;
    public static final int STEPS;
    public static final int NBTHREADS;
    public static final int SPLITPOINT;
    public static final int ACCEL;
    public static final int ZPARAMS;

    protected ZDICTFastCoverParams(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected ZDICTFastCoverParams create(long address, @Nullable ByteBuffer container) {
        return new ZDICTFastCoverParams(address, container);
    }

    public ZDICTFastCoverParams(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), ZDICTFastCoverParams.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned")
    public int k() {
        return ZDICTFastCoverParams.nk(this.address());
    }

    @NativeType(value="unsigned")
    public int d() {
        return ZDICTFastCoverParams.nd(this.address());
    }

    @NativeType(value="unsigned")
    public int f() {
        return ZDICTFastCoverParams.nf(this.address());
    }

    @NativeType(value="unsigned")
    public int steps() {
        return ZDICTFastCoverParams.nsteps(this.address());
    }

    @NativeType(value="unsigned")
    public int nbThreads() {
        return ZDICTFastCoverParams.nnbThreads(this.address());
    }

    public double splitPoint() {
        return ZDICTFastCoverParams.nsplitPoint(this.address());
    }

    @NativeType(value="unsigned")
    public int accel() {
        return ZDICTFastCoverParams.naccel(this.address());
    }

    @NativeType(value="ZDICT_params_t")
    public ZDICTParams zParams() {
        return ZDICTFastCoverParams.nzParams(this.address());
    }

    public ZDICTFastCoverParams k(@NativeType(value="unsigned") int value) {
        ZDICTFastCoverParams.nk(this.address(), value);
        return this;
    }

    public ZDICTFastCoverParams d(@NativeType(value="unsigned") int value) {
        ZDICTFastCoverParams.nd(this.address(), value);
        return this;
    }

    public ZDICTFastCoverParams f(@NativeType(value="unsigned") int value) {
        ZDICTFastCoverParams.nf(this.address(), value);
        return this;
    }

    public ZDICTFastCoverParams steps(@NativeType(value="unsigned") int value) {
        ZDICTFastCoverParams.nsteps(this.address(), value);
        return this;
    }

    public ZDICTFastCoverParams nbThreads(@NativeType(value="unsigned") int value) {
        ZDICTFastCoverParams.nnbThreads(this.address(), value);
        return this;
    }

    public ZDICTFastCoverParams splitPoint(double value) {
        ZDICTFastCoverParams.nsplitPoint(this.address(), value);
        return this;
    }

    public ZDICTFastCoverParams accel(@NativeType(value="unsigned") int value) {
        ZDICTFastCoverParams.naccel(this.address(), value);
        return this;
    }

    public ZDICTFastCoverParams zParams(@NativeType(value="ZDICT_params_t") ZDICTParams value) {
        ZDICTFastCoverParams.nzParams(this.address(), value);
        return this;
    }

    public ZDICTFastCoverParams zParams(Consumer<ZDICTParams> consumer) {
        consumer.accept(this.zParams());
        return this;
    }

    public ZDICTFastCoverParams set(int k, int d, int f, int steps, int nbThreads, double splitPoint, int accel, ZDICTParams zParams) {
        this.k(k);
        this.d(d);
        this.f(f);
        this.steps(steps);
        this.nbThreads(nbThreads);
        this.splitPoint(splitPoint);
        this.accel(accel);
        this.zParams(zParams);
        return this;
    }

    public ZDICTFastCoverParams set(ZDICTFastCoverParams src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static ZDICTFastCoverParams malloc() {
        return new ZDICTFastCoverParams(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static ZDICTFastCoverParams calloc() {
        return new ZDICTFastCoverParams(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static ZDICTFastCoverParams create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new ZDICTFastCoverParams(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static ZDICTFastCoverParams create(long address) {
        return new ZDICTFastCoverParams(address, null);
    }

    public static @Nullable ZDICTFastCoverParams createSafe(long address) {
        return address == 0L ? null : new ZDICTFastCoverParams(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)ZDICTFastCoverParams.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = ZDICTFastCoverParams.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static ZDICTFastCoverParams mallocStack() {
        return ZDICTFastCoverParams.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ZDICTFastCoverParams callocStack() {
        return ZDICTFastCoverParams.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ZDICTFastCoverParams mallocStack(MemoryStack stack) {
        return ZDICTFastCoverParams.malloc(stack);
    }

    @Deprecated
    public static ZDICTFastCoverParams callocStack(MemoryStack stack) {
        return ZDICTFastCoverParams.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return ZDICTFastCoverParams.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return ZDICTFastCoverParams.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return ZDICTFastCoverParams.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return ZDICTFastCoverParams.calloc(capacity, stack);
    }

    public static ZDICTFastCoverParams malloc(MemoryStack stack) {
        return new ZDICTFastCoverParams(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static ZDICTFastCoverParams calloc(MemoryStack stack) {
        return new ZDICTFastCoverParams(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nk(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)K));
    }

    public static int nd(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)D));
    }

    public static int nf(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)F));
    }

    public static int nsteps(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STEPS));
    }

    public static int nnbThreads(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)NBTHREADS));
    }

    public static double nsplitPoint(long struct) {
        return MemoryUtil.memGetDouble((long)(struct + (long)SPLITPOINT));
    }

    public static int naccel(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)ACCEL));
    }

    public static ZDICTParams nzParams(long struct) {
        return ZDICTParams.create(struct + (long)ZPARAMS);
    }

    public static void nk(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)K), (int)value);
    }

    public static void nd(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)D), (int)value);
    }

    public static void nf(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)F), (int)value);
    }

    public static void nsteps(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STEPS), (int)value);
    }

    public static void nnbThreads(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)NBTHREADS), (int)value);
    }

    public static void nsplitPoint(long struct, double value) {
        MemoryUtil.memPutDouble((long)(struct + (long)SPLITPOINT), (double)value);
    }

    public static void naccel(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)ACCEL), (int)value);
    }

    public static void nzParams(long struct, ZDICTParams value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)ZPARAMS), (long)ZDICTParams.SIZEOF);
    }

    static {
        Struct.Layout layout = ZDICTFastCoverParams.__struct((Struct.Member[])new Struct.Member[]{ZDICTFastCoverParams.__member((int)4), ZDICTFastCoverParams.__member((int)4), ZDICTFastCoverParams.__member((int)4), ZDICTFastCoverParams.__member((int)4), ZDICTFastCoverParams.__member((int)4), ZDICTFastCoverParams.__member((int)8), ZDICTFastCoverParams.__member((int)4), ZDICTFastCoverParams.__member((int)ZDICTParams.SIZEOF, (int)ZDICTParams.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        K = layout.offsetof(0);
        D = layout.offsetof(1);
        F = layout.offsetof(2);
        STEPS = layout.offsetof(3);
        NBTHREADS = layout.offsetof(4);
        SPLITPOINT = layout.offsetof(5);
        ACCEL = layout.offsetof(6);
        ZPARAMS = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<ZDICTFastCoverParams, Buffer>
    implements NativeResource {
        private static final ZDICTFastCoverParams ELEMENT_FACTORY = ZDICTFastCoverParams.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected ZDICTFastCoverParams getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned")
        public int k() {
            return ZDICTFastCoverParams.nk(this.address());
        }

        @NativeType(value="unsigned")
        public int d() {
            return ZDICTFastCoverParams.nd(this.address());
        }

        @NativeType(value="unsigned")
        public int f() {
            return ZDICTFastCoverParams.nf(this.address());
        }

        @NativeType(value="unsigned")
        public int steps() {
            return ZDICTFastCoverParams.nsteps(this.address());
        }

        @NativeType(value="unsigned")
        public int nbThreads() {
            return ZDICTFastCoverParams.nnbThreads(this.address());
        }

        public double splitPoint() {
            return ZDICTFastCoverParams.nsplitPoint(this.address());
        }

        @NativeType(value="unsigned")
        public int accel() {
            return ZDICTFastCoverParams.naccel(this.address());
        }

        @NativeType(value="ZDICT_params_t")
        public ZDICTParams zParams() {
            return ZDICTFastCoverParams.nzParams(this.address());
        }

        public Buffer k(@NativeType(value="unsigned") int value) {
            ZDICTFastCoverParams.nk(this.address(), value);
            return this;
        }

        public Buffer d(@NativeType(value="unsigned") int value) {
            ZDICTFastCoverParams.nd(this.address(), value);
            return this;
        }

        public Buffer f(@NativeType(value="unsigned") int value) {
            ZDICTFastCoverParams.nf(this.address(), value);
            return this;
        }

        public Buffer steps(@NativeType(value="unsigned") int value) {
            ZDICTFastCoverParams.nsteps(this.address(), value);
            return this;
        }

        public Buffer nbThreads(@NativeType(value="unsigned") int value) {
            ZDICTFastCoverParams.nnbThreads(this.address(), value);
            return this;
        }

        public Buffer splitPoint(double value) {
            ZDICTFastCoverParams.nsplitPoint(this.address(), value);
            return this;
        }

        public Buffer accel(@NativeType(value="unsigned") int value) {
            ZDICTFastCoverParams.naccel(this.address(), value);
            return this;
        }

        public Buffer zParams(@NativeType(value="ZDICT_params_t") ZDICTParams value) {
            ZDICTFastCoverParams.nzParams(this.address(), value);
            return this;
        }

        public Buffer zParams(Consumer<ZDICTParams> consumer) {
            consumer.accept(this.zParams());
            return this;
        }
    }
}

