/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.zstd;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ZDICT_params_t")
public class ZDICTParams
extends Struct<ZDICTParams>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int COMPRESSIONLEVEL;
    public static final int NOTIFICATIONLEVEL;
    public static final int DICTID;

    protected ZDICTParams(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected ZDICTParams create(long address, @Nullable ByteBuffer container) {
        return new ZDICTParams(address, container);
    }

    public ZDICTParams(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), ZDICTParams.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public int compressionLevel() {
        return ZDICTParams.ncompressionLevel(this.address());
    }

    @NativeType(value="unsigned")
    public int notificationLevel() {
        return ZDICTParams.nnotificationLevel(this.address());
    }

    @NativeType(value="unsigned")
    public int dictID() {
        return ZDICTParams.ndictID(this.address());
    }

    public ZDICTParams compressionLevel(int value) {
        ZDICTParams.ncompressionLevel(this.address(), value);
        return this;
    }

    public ZDICTParams notificationLevel(@NativeType(value="unsigned") int value) {
        ZDICTParams.nnotificationLevel(this.address(), value);
        return this;
    }

    public ZDICTParams dictID(@NativeType(value="unsigned") int value) {
        ZDICTParams.ndictID(this.address(), value);
        return this;
    }

    public ZDICTParams set(int compressionLevel, int notificationLevel, int dictID) {
        this.compressionLevel(compressionLevel);
        this.notificationLevel(notificationLevel);
        this.dictID(dictID);
        return this;
    }

    public ZDICTParams set(ZDICTParams src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static ZDICTParams malloc() {
        return new ZDICTParams(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static ZDICTParams calloc() {
        return new ZDICTParams(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static ZDICTParams create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new ZDICTParams(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static ZDICTParams create(long address) {
        return new ZDICTParams(address, null);
    }

    public static @Nullable ZDICTParams createSafe(long address) {
        return address == 0L ? null : new ZDICTParams(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)ZDICTParams.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = ZDICTParams.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static ZDICTParams mallocStack() {
        return ZDICTParams.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ZDICTParams callocStack() {
        return ZDICTParams.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ZDICTParams mallocStack(MemoryStack stack) {
        return ZDICTParams.malloc(stack);
    }

    @Deprecated
    public static ZDICTParams callocStack(MemoryStack stack) {
        return ZDICTParams.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return ZDICTParams.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return ZDICTParams.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return ZDICTParams.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return ZDICTParams.calloc(capacity, stack);
    }

    public static ZDICTParams malloc(MemoryStack stack) {
        return new ZDICTParams(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static ZDICTParams calloc(MemoryStack stack) {
        return new ZDICTParams(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ncompressionLevel(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)COMPRESSIONLEVEL));
    }

    public static int nnotificationLevel(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)NOTIFICATIONLEVEL));
    }

    public static int ndictID(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)DICTID));
    }

    public static void ncompressionLevel(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)COMPRESSIONLEVEL), (int)value);
    }

    public static void nnotificationLevel(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)NOTIFICATIONLEVEL), (int)value);
    }

    public static void ndictID(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)DICTID), (int)value);
    }

    static {
        Struct.Layout layout = ZDICTParams.__struct((Struct.Member[])new Struct.Member[]{ZDICTParams.__member((int)4), ZDICTParams.__member((int)4), ZDICTParams.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        COMPRESSIONLEVEL = layout.offsetof(0);
        NOTIFICATIONLEVEL = layout.offsetof(1);
        DICTID = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<ZDICTParams, Buffer>
    implements NativeResource {
        private static final ZDICTParams ELEMENT_FACTORY = ZDICTParams.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected ZDICTParams getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public int compressionLevel() {
            return ZDICTParams.ncompressionLevel(this.address());
        }

        @NativeType(value="unsigned")
        public int notificationLevel() {
            return ZDICTParams.nnotificationLevel(this.address());
        }

        @NativeType(value="unsigned")
        public int dictID() {
            return ZDICTParams.ndictID(this.address());
        }

        public Buffer compressionLevel(int value) {
            ZDICTParams.ncompressionLevel(this.address(), value);
            return this;
        }

        public Buffer notificationLevel(@NativeType(value="unsigned") int value) {
            ZDICTParams.nnotificationLevel(this.address(), value);
            return this;
        }

        public Buffer dictID(@NativeType(value="unsigned") int value) {
            ZDICTParams.ndictID(this.address(), value);
            return this;
        }
    }
}

