/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.zstd;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ZSTD_frameHeader")
public class ZSTDFrameHeader
extends Struct<ZSTDFrameHeader>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FRAMECONTENTSIZE;
    public static final int WINDOWSIZE;
    public static final int BLOCKSIZEMAX;
    public static final int FRAMETYPE;
    public static final int HEADERSIZE;
    public static final int DICTID;
    public static final int CHECKSUMFLAG;
    public static final int _RESERVED1;
    public static final int _RESERVED2;

    protected ZSTDFrameHeader(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected ZSTDFrameHeader create(long address, @Nullable ByteBuffer container) {
        return new ZSTDFrameHeader(address, container);
    }

    public ZSTDFrameHeader(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), ZSTDFrameHeader.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned long long")
    public long frameContentSize() {
        return ZSTDFrameHeader.nframeContentSize(this.address());
    }

    @NativeType(value="unsigned long long")
    public long windowSize() {
        return ZSTDFrameHeader.nwindowSize(this.address());
    }

    @NativeType(value="unsigned int")
    public int blockSizeMax() {
        return ZSTDFrameHeader.nblockSizeMax(this.address());
    }

    @NativeType(value="ZSTD_frameType_e")
    public int frameType() {
        return ZSTDFrameHeader.nframeType(this.address());
    }

    @NativeType(value="unsigned int")
    public int headerSize() {
        return ZSTDFrameHeader.nheaderSize(this.address());
    }

    @NativeType(value="unsigned int")
    public int dictID() {
        return ZSTDFrameHeader.ndictID(this.address());
    }

    @NativeType(value="unsigned int")
    public int checksumFlag() {
        return ZSTDFrameHeader.nchecksumFlag(this.address());
    }

    public static ZSTDFrameHeader malloc() {
        return new ZSTDFrameHeader(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static ZSTDFrameHeader calloc() {
        return new ZSTDFrameHeader(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static ZSTDFrameHeader create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new ZSTDFrameHeader(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static ZSTDFrameHeader create(long address) {
        return new ZSTDFrameHeader(address, null);
    }

    public static @Nullable ZSTDFrameHeader createSafe(long address) {
        return address == 0L ? null : new ZSTDFrameHeader(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)ZSTDFrameHeader.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = ZSTDFrameHeader.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static ZSTDFrameHeader mallocStack() {
        return ZSTDFrameHeader.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ZSTDFrameHeader callocStack() {
        return ZSTDFrameHeader.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ZSTDFrameHeader mallocStack(MemoryStack stack) {
        return ZSTDFrameHeader.malloc(stack);
    }

    @Deprecated
    public static ZSTDFrameHeader callocStack(MemoryStack stack) {
        return ZSTDFrameHeader.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return ZSTDFrameHeader.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return ZSTDFrameHeader.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return ZSTDFrameHeader.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return ZSTDFrameHeader.calloc(capacity, stack);
    }

    public static ZSTDFrameHeader malloc(MemoryStack stack) {
        return new ZSTDFrameHeader(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static ZSTDFrameHeader calloc(MemoryStack stack) {
        return new ZSTDFrameHeader(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nframeContentSize(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)FRAMECONTENTSIZE));
    }

    public static long nwindowSize(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)WINDOWSIZE));
    }

    public static int nblockSizeMax(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)BLOCKSIZEMAX));
    }

    public static int nframeType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FRAMETYPE));
    }

    public static int nheaderSize(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)HEADERSIZE));
    }

    public static int ndictID(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)DICTID));
    }

    public static int nchecksumFlag(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)CHECKSUMFLAG));
    }

    public static int n_reserved1(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)_RESERVED1));
    }

    public static int n_reserved2(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)_RESERVED2));
    }

    static {
        Struct.Layout layout = ZSTDFrameHeader.__struct((Struct.Member[])new Struct.Member[]{ZSTDFrameHeader.__member((int)8), ZSTDFrameHeader.__member((int)8), ZSTDFrameHeader.__member((int)4), ZSTDFrameHeader.__member((int)4), ZSTDFrameHeader.__member((int)4), ZSTDFrameHeader.__member((int)4), ZSTDFrameHeader.__member((int)4), ZSTDFrameHeader.__member((int)4), ZSTDFrameHeader.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FRAMECONTENTSIZE = layout.offsetof(0);
        WINDOWSIZE = layout.offsetof(1);
        BLOCKSIZEMAX = layout.offsetof(2);
        FRAMETYPE = layout.offsetof(3);
        HEADERSIZE = layout.offsetof(4);
        DICTID = layout.offsetof(5);
        CHECKSUMFLAG = layout.offsetof(6);
        _RESERVED1 = layout.offsetof(7);
        _RESERVED2 = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<ZSTDFrameHeader, Buffer>
    implements NativeResource {
        private static final ZSTDFrameHeader ELEMENT_FACTORY = ZSTDFrameHeader.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected ZSTDFrameHeader getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned long long")
        public long frameContentSize() {
            return ZSTDFrameHeader.nframeContentSize(this.address());
        }

        @NativeType(value="unsigned long long")
        public long windowSize() {
            return ZSTDFrameHeader.nwindowSize(this.address());
        }

        @NativeType(value="unsigned int")
        public int blockSizeMax() {
            return ZSTDFrameHeader.nblockSizeMax(this.address());
        }

        @NativeType(value="ZSTD_frameType_e")
        public int frameType() {
            return ZSTDFrameHeader.nframeType(this.address());
        }

        @NativeType(value="unsigned int")
        public int headerSize() {
            return ZSTDFrameHeader.nheaderSize(this.address());
        }

        @NativeType(value="unsigned int")
        public int dictID() {
            return ZSTDFrameHeader.ndictID(this.address());
        }

        @NativeType(value="unsigned int")
        public int checksumFlag() {
            return ZSTDFrameHeader.nchecksumFlag(this.address());
        }
    }
}

