/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.zstd;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ZSTD_outBuffer")
public class ZSTDOutBuffer
extends Struct<ZSTDOutBuffer>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DST;
    public static final int SIZE;
    public static final int POS;

    protected ZSTDOutBuffer(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected ZSTDOutBuffer create(long address, @Nullable ByteBuffer container) {
        return new ZSTDOutBuffer(address, container);
    }

    public ZSTDOutBuffer(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), ZSTDOutBuffer.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *")
    public ByteBuffer dst() {
        return ZSTDOutBuffer.ndst(this.address());
    }

    @NativeType(value="size_t")
    public long size() {
        return ZSTDOutBuffer.nsize(this.address());
    }

    @NativeType(value="size_t")
    public long pos() {
        return ZSTDOutBuffer.npos(this.address());
    }

    public ZSTDOutBuffer dst(@NativeType(value="void *") ByteBuffer value) {
        ZSTDOutBuffer.ndst(this.address(), value);
        return this;
    }

    public ZSTDOutBuffer pos(@NativeType(value="size_t") long value) {
        ZSTDOutBuffer.npos(this.address(), value);
        return this;
    }

    public ZSTDOutBuffer set(ByteBuffer dst, long pos) {
        this.dst(dst);
        this.pos(pos);
        return this;
    }

    public ZSTDOutBuffer set(ZSTDOutBuffer src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static ZSTDOutBuffer malloc() {
        return new ZSTDOutBuffer(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static ZSTDOutBuffer calloc() {
        return new ZSTDOutBuffer(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static ZSTDOutBuffer create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new ZSTDOutBuffer(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static ZSTDOutBuffer create(long address) {
        return new ZSTDOutBuffer(address, null);
    }

    public static @Nullable ZSTDOutBuffer createSafe(long address) {
        return address == 0L ? null : new ZSTDOutBuffer(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)ZSTDOutBuffer.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = ZSTDOutBuffer.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static ZSTDOutBuffer mallocStack() {
        return ZSTDOutBuffer.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ZSTDOutBuffer callocStack() {
        return ZSTDOutBuffer.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ZSTDOutBuffer mallocStack(MemoryStack stack) {
        return ZSTDOutBuffer.malloc(stack);
    }

    @Deprecated
    public static ZSTDOutBuffer callocStack(MemoryStack stack) {
        return ZSTDOutBuffer.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return ZSTDOutBuffer.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return ZSTDOutBuffer.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return ZSTDOutBuffer.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return ZSTDOutBuffer.calloc(capacity, stack);
    }

    public static ZSTDOutBuffer malloc(MemoryStack stack) {
        return new ZSTDOutBuffer(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static ZSTDOutBuffer calloc(MemoryStack stack) {
        return new ZSTDOutBuffer(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer ndst(long struct) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)DST)), (int)((int)ZSTDOutBuffer.nsize(struct)));
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SIZE));
    }

    public static long npos(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)POS));
    }

    public static void ndst(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DST), (long)MemoryUtil.memAddress((ByteBuffer)value));
        ZSTDOutBuffer.nsize(struct, value.remaining());
    }

    public static void nsize(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SIZE), (long)value);
    }

    public static void npos(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)POS), (long)value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)DST)));
    }

    static {
        Struct.Layout layout = ZSTDOutBuffer.__struct((Struct.Member[])new Struct.Member[]{ZSTDOutBuffer.__member((int)POINTER_SIZE), ZSTDOutBuffer.__member((int)POINTER_SIZE), ZSTDOutBuffer.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DST = layout.offsetof(0);
        SIZE = layout.offsetof(1);
        POS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<ZSTDOutBuffer, Buffer>
    implements NativeResource {
        private static final ZSTDOutBuffer ELEMENT_FACTORY = ZSTDOutBuffer.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected ZSTDOutBuffer getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void *")
        public ByteBuffer dst() {
            return ZSTDOutBuffer.ndst(this.address());
        }

        @NativeType(value="size_t")
        public long size() {
            return ZSTDOutBuffer.nsize(this.address());
        }

        @NativeType(value="size_t")
        public long pos() {
            return ZSTDOutBuffer.npos(this.address());
        }

        public Buffer dst(@NativeType(value="void *") ByteBuffer value) {
            ZSTDOutBuffer.ndst(this.address(), value);
            return this;
        }

        public Buffer pos(@NativeType(value="size_t") long value) {
            ZSTDOutBuffer.npos(this.address(), value);
            return this;
        }
    }
}

